/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticloadbalancing.model.Listener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateLoadBalancerListenersRequest
extends AmazonWebServiceRequest {
    private String loadBalancerName;
    private List<Listener> listeners;

    public CreateLoadBalancerListenersRequest() {
    }

    public CreateLoadBalancerListenersRequest(String loadBalancerName, List<Listener> listeners) {
        this.loadBalancerName = loadBalancerName;
        this.listeners = listeners;
    }

    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public CreateLoadBalancerListenersRequest withLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
        return this;
    }

    public List<Listener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Listener>();
        }
        return this.listeners;
    }

    public void setListeners(Collection<Listener> listeners) {
        ArrayList<Listener> listenersCopy = new ArrayList<Listener>();
        if (listeners != null) {
            listenersCopy.addAll(listeners);
        }
        this.listeners = listenersCopy;
    }

    public CreateLoadBalancerListenersRequest withListeners(Listener ... listeners) {
        for (Listener value : listeners) {
            this.getListeners().add(value);
        }
        return this;
    }

    public CreateLoadBalancerListenersRequest withListeners(Collection<Listener> listeners) {
        ArrayList<Listener> listenersCopy = new ArrayList<Listener>();
        if (listeners != null) {
            listenersCopy.addAll(listeners);
        }
        this.listeners = listenersCopy;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("LoadBalancerName: " + this.loadBalancerName + ", ");
        sb.append("Listeners: " + this.listeners + ", ");
        sb.append("}");
        return sb.toString();
    }
}

