/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishRequestMarshaller
implements Marshaller<Request<PublishRequest>, PublishRequest> {
    @Override
    public Request<PublishRequest> marshall(PublishRequest publishRequest) {
        DefaultRequest<PublishRequest> request = new DefaultRequest<PublishRequest>(publishRequest, "AmazonSNS");
        request.addParameter("Action", "Publish");
        request.addParameter("Version", "2010-03-31");
        if (publishRequest != null && publishRequest.getTopicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString(publishRequest.getTopicArn()));
        }
        if (publishRequest != null && publishRequest.getMessage() != null) {
            request.addParameter("Message", StringUtils.fromString(publishRequest.getMessage()));
        }
        if (publishRequest != null && publishRequest.getSubject() != null) {
            request.addParameter("Subject", StringUtils.fromString(publishRequest.getSubject()));
        }
        return request;
    }
}

