/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.rds.model.RestoreDBInstanceToPointInTimeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreDBInstanceToPointInTimeRequestMarshaller
implements Marshaller<Request<RestoreDBInstanceToPointInTimeRequest>, RestoreDBInstanceToPointInTimeRequest> {
    @Override
    public Request<RestoreDBInstanceToPointInTimeRequest> marshall(RestoreDBInstanceToPointInTimeRequest restoreDBInstanceToPointInTimeRequest) {
        DefaultRequest<RestoreDBInstanceToPointInTimeRequest> request = new DefaultRequest<RestoreDBInstanceToPointInTimeRequest>(restoreDBInstanceToPointInTimeRequest, "AmazonRDS");
        request.addParameter("Action", "RestoreDBInstanceToPointInTime");
        request.addParameter("Version", "2010-01-01");
        if (restoreDBInstanceToPointInTimeRequest != null && restoreDBInstanceToPointInTimeRequest.getSourceDBInstanceIdentifier() != null) {
            request.addParameter("SourceDBInstanceIdentifier", StringUtils.fromString(restoreDBInstanceToPointInTimeRequest.getSourceDBInstanceIdentifier()));
        }
        if (restoreDBInstanceToPointInTimeRequest != null && restoreDBInstanceToPointInTimeRequest.getTargetDBInstanceIdentifier() != null) {
            request.addParameter("TargetDBInstanceIdentifier", StringUtils.fromString(restoreDBInstanceToPointInTimeRequest.getTargetDBInstanceIdentifier()));
        }
        if (restoreDBInstanceToPointInTimeRequest != null && restoreDBInstanceToPointInTimeRequest.getRestoreTime() != null) {
            request.addParameter("RestoreTime", StringUtils.fromDate(restoreDBInstanceToPointInTimeRequest.getRestoreTime()));
        }
        if (restoreDBInstanceToPointInTimeRequest != null && restoreDBInstanceToPointInTimeRequest.isUseLatestRestorableTime() != null) {
            request.addParameter("UseLatestRestorableTime", StringUtils.fromBoolean(restoreDBInstanceToPointInTimeRequest.isUseLatestRestorableTime()));
        }
        if (restoreDBInstanceToPointInTimeRequest != null && restoreDBInstanceToPointInTimeRequest.getDBInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString(restoreDBInstanceToPointInTimeRequest.getDBInstanceClass()));
        }
        if (restoreDBInstanceToPointInTimeRequest != null && restoreDBInstanceToPointInTimeRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger(restoreDBInstanceToPointInTimeRequest.getPort()));
        }
        if (restoreDBInstanceToPointInTimeRequest != null && restoreDBInstanceToPointInTimeRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString(restoreDBInstanceToPointInTimeRequest.getAvailabilityZone()));
        }
        if (restoreDBInstanceToPointInTimeRequest != null && restoreDBInstanceToPointInTimeRequest.isMultiAZ() != null) {
            request.addParameter("MultiAZ", StringUtils.fromBoolean(restoreDBInstanceToPointInTimeRequest.isMultiAZ()));
        }
        return request;
    }
}

