/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.QueryStringSigner;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.HttpClient;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpRequest;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsResult;
import com.amazonaws.services.cloudwatch.model.ListMetricsRequest;
import com.amazonaws.services.cloudwatch.model.ListMetricsResult;
import com.amazonaws.services.cloudwatch.model.transform.GetMetricStatisticsRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.GetMetricStatisticsResultStaxUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.InternalServiceExceptionUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.InvalidParameterCombinationExceptionUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.ListMetricsRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.ListMetricsResultStaxUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.MissingRequiredParameterExceptionUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonCloudWatchClient
extends AmazonWebServiceClient
implements AmazonCloudWatch {
    private AWSCredentials awsCredentials;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;
    protected final HttpClient client;
    private List<RequestHandler> requestHandlers = new ArrayList<RequestHandler>();

    public AmazonCloudWatchClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonCloudWatchClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentials = awsCredentials;
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
        this.exceptionUnmarshallers.add(new InternalServiceExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidParameterCombinationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MissingRequiredParameterExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidParameterValueExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("monitoring.amazonaws.com");
        this.requestHandlers = new HandlerChainFactory().newRequestHandlerChain("/com/amazonaws/services/cloudwatch/request.handlers");
        this.client = new HttpClient(clientConfiguration);
    }

    @Override
    public ListMetricsResult listMetrics(ListMetricsRequest listMetricsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListMetricsRequest> request = new ListMetricsRequestMarshaller().marshall(listMetricsRequest);
        return this.invoke(request, new ListMetricsResultStaxUnmarshaller());
    }

    @Override
    public GetMetricStatisticsResult getMetricStatistics(GetMetricStatisticsRequest getMetricStatisticsRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetMetricStatisticsRequest> request = new GetMetricStatisticsRequestMarshaller().marshall(getMetricStatisticsRequest);
        return this.invoke(request, new GetMetricStatisticsResultStaxUnmarshaller());
    }

    @Override
    public ListMetricsResult listMetrics() throws AmazonServiceException, AmazonClientException {
        return this.listMetrics(new ListMetricsRequest());
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        if (this.requestHandlers != null) {
            for (RequestHandler requestHandler : this.requestHandlers) {
                request = requestHandler.handleRequest(request);
            }
        }
        QueryStringSigner<Y> signer = new QueryStringSigner<Y>(this.awsCredentials);
        try {
            signer.sign(request);
        }
        catch (SignatureException e) {
            throw new AmazonServiceException("Unable to sign request", e);
        }
        HttpRequest httpRequest = new HttpRequest(HttpMethodName.POST);
        for (Map.Entry<String, String> parameter : request.getParameters().entrySet()) {
            httpRequest.addParameter(parameter.getKey(), parameter.getValue());
        }
        httpRequest.setServiceName(request.getServiceName());
        httpRequest.setEndpoint(request.getEndpoint());
        httpRequest.setResourcePath(request.getResourcePath());
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(httpRequest, responseHandler, errorResponseHandler);
    }
}

