/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.ResponseMetadata;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.VoidStaxUnmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxResponseHandler<T>
implements HttpResponseHandler<ResponseMetadata<T>> {
    private Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller;
    private String requestIdPath = null;
    private static final Log log = LogFactory.getLog((String)"com.amazonaws.request");
    private static XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    public StaxResponseHandler(Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
        if (this.responseUnmarshaller == null) {
            this.responseUnmarshaller = new VoidStaxUnmarshaller();
        }
    }

    public StaxResponseHandler(Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller, String requestIdPath) {
        this(responseUnmarshaller);
        this.requestIdPath = requestIdPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseMetadata<T> handle(HttpResponse response) throws Exception {
        if (this.requestIdPath != null) {
            // empty if block
        }
        log.trace((Object)"Parsing service response XML");
        XMLEventReader eventReader = xmlInputFactory.createXMLEventReader(response.getContent());
        try {
            ResponseMetadata<T> responseMetadata = new ResponseMetadata<T>();
            StaxUnmarshallerContext unmarshallerContext = new StaxUnmarshallerContext(eventReader, responseMetadata);
            T result = this.responseUnmarshaller.unmarshall(unmarshallerContext);
            responseMetadata.setResult(result);
            log.trace((Object)"Done parsing service response");
            ResponseMetadata<T> responseMetadata2 = responseMetadata;
            return responseMetadata2;
        }
        finally {
            try {
                eventReader.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
    }
}

