/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageUnmarshaller
implements Unmarshaller<Message, Node> {
    @Override
    public Message unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        Message message = new Message();
        Node messageIdNode = XpathUtils.asNode("MessageId", node);
        message.setMessageId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(messageIdNode));
        Node receiptHandleNode = XpathUtils.asNode("ReceiptHandle", node);
        message.setReceiptHandle(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(receiptHandleNode));
        Node mD5OfBodyNode = XpathUtils.asNode("MD5OfBody", node);
        message.setMD5OfBody(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(mD5OfBodyNode));
        Node bodyNode = XpathUtils.asNode("Body", node);
        message.setBody(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(bodyNode));
        NodeList attributesNodes = XpathUtils.asNodeList("Attribute", node);
        for (int attributesIndex = 0; attributesIndex < XpathUtils.nodeLength(attributesNodes); ++attributesIndex) {
            String attributesMapKey = new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(XpathUtils.asNode("Name", attributesNodes.item(attributesIndex)));
            String attributesMapValue = new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(XpathUtils.asNode("Value", attributesNodes.item(attributesIndex)));
            message.getAttributes().put(attributesMapKey, attributesMapValue);
        }
        return message;
    }
}

