/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.DBSnapshot;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBSnapshotUnmarshaller
implements Unmarshaller<DBSnapshot, Node> {
    @Override
    public DBSnapshot unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        DBSnapshot dBSnapshot = new DBSnapshot();
        Node dBSnapshotIdentifierNode = XpathUtils.asNode("DBSnapshotIdentifier", node);
        dBSnapshot.setDBSnapshotIdentifier(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(dBSnapshotIdentifierNode));
        Node dBInstanceIdentifierNode = XpathUtils.asNode("DBInstanceIdentifier", node);
        dBSnapshot.setDBInstanceIdentifier(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(dBInstanceIdentifierNode));
        Node snapshotCreateTimeNode = XpathUtils.asNode("SnapshotCreateTime", node);
        dBSnapshot.setSnapshotCreateTime(new SimpleTypeUnmarshallers.DateUnmarshaller().unmarshall(snapshotCreateTimeNode));
        Node engineNode = XpathUtils.asNode("Engine", node);
        dBSnapshot.setEngine(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(engineNode));
        Node allocatedStorageNode = XpathUtils.asNode("AllocatedStorage", node);
        dBSnapshot.setAllocatedStorage(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(allocatedStorageNode));
        Node statusNode = XpathUtils.asNode("Status", node);
        dBSnapshot.setStatus(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(statusNode));
        Node portNode = XpathUtils.asNode("Port", node);
        dBSnapshot.setPort(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(portNode));
        Node availabilityZoneNode = XpathUtils.asNode("AvailabilityZone", node);
        dBSnapshot.setAvailabilityZone(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(availabilityZoneNode));
        Node instanceCreateTimeNode = XpathUtils.asNode("InstanceCreateTime", node);
        dBSnapshot.setInstanceCreateTime(new SimpleTypeUnmarshallers.DateUnmarshaller().unmarshall(instanceCreateTimeNode));
        Node masterUsernameNode = XpathUtils.asNode("MasterUsername", node);
        dBSnapshot.setMasterUsername(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(masterUsernameNode));
        return dBSnapshot;
    }
}

