/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig;
import com.amazonaws.services.elasticmapreduce.model.transform.KeyValueUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HadoopJarStepConfigUnmarshaller
implements Unmarshaller<HadoopJarStepConfig, Node> {
    @Override
    public HadoopJarStepConfig unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        HadoopJarStepConfig hadoopJarStepConfig = new HadoopJarStepConfig();
        NodeList propertiesNodes = XpathUtils.asNodeList("Properties/member", node);
        for (int propertiesIndex = 0; propertiesIndex < XpathUtils.nodeLength(propertiesNodes); ++propertiesIndex) {
            Node propertiesNode = propertiesNodes.item(propertiesIndex);
            hadoopJarStepConfig.getProperties().add(new KeyValueUnmarshaller().unmarshall(propertiesNode));
            propertiesNode.getParentNode().removeChild(propertiesNode);
        }
        Node jarNode = XpathUtils.asNode("Jar", node);
        hadoopJarStepConfig.setJar(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(jarNode));
        Node mainClassNode = XpathUtils.asNode("MainClass", node);
        hadoopJarStepConfig.setMainClass(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(mainClassNode));
        NodeList argsNodes = XpathUtils.asNodeList("Args/member", node);
        for (int argsIndex = 0; argsIndex < XpathUtils.nodeLength(argsNodes); ++argsIndex) {
            Node argsNode = argsNodes.item(argsIndex);
            hadoopJarStepConfig.getArgs().add(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(argsNode));
            argsNode.getParentNode().removeChild(argsNode);
        }
        return hadoopJarStepConfig;
    }
}

