/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.S3Storage;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3StorageUnmarshaller
implements Unmarshaller<S3Storage, Node> {
    @Override
    public S3Storage unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        S3Storage s3Storage = new S3Storage();
        Node bucketNode = XpathUtils.asNode("bucket", node);
        s3Storage.setBucket(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(bucketNode));
        Node prefixNode = XpathUtils.asNode("prefix", node);
        s3Storage.setPrefix(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(prefixNode));
        Node aWSAccessKeyIdNode = XpathUtils.asNode("awsAccessKeyId", node);
        s3Storage.setAWSAccessKeyId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(aWSAccessKeyIdNode));
        Node uploadPolicyNode = XpathUtils.asNode("uploadPolicy", node);
        s3Storage.setUploadPolicy(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(uploadPolicyNode));
        Node uploadPolicySignatureNode = XpathUtils.asNode("uploadPolicySignature", node);
        s3Storage.setUploadPolicySignature(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(uploadPolicySignatureNode));
        return s3Storage;
    }
}

