/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.InstanceAttribute;
import com.amazonaws.services.ec2.model.transform.InstanceBlockDeviceMappingUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceAttributeUnmarshaller
implements Unmarshaller<InstanceAttribute, Node> {
    @Override
    public InstanceAttribute unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        InstanceAttribute instanceAttribute = new InstanceAttribute();
        Node instanceIdNode = XpathUtils.asNode("instanceId", node);
        instanceAttribute.setInstanceId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(instanceIdNode));
        Node instanceTypeNode = XpathUtils.asNode("instanceType/value", node);
        instanceAttribute.setInstanceType(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(instanceTypeNode));
        Node kernelIdNode = XpathUtils.asNode("kernel/value", node);
        instanceAttribute.setKernelId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(kernelIdNode));
        Node ramdiskIdNode = XpathUtils.asNode("ramdisk/value", node);
        instanceAttribute.setRamdiskId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(ramdiskIdNode));
        Node userDataNode = XpathUtils.asNode("userData/value", node);
        instanceAttribute.setUserData(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(userDataNode));
        Node disableApiTerminationNode = XpathUtils.asNode("disableApiTermination/value", node);
        instanceAttribute.setDisableApiTermination(new SimpleTypeUnmarshallers.BooleanUnmarshaller().unmarshall(disableApiTerminationNode));
        Node instanceInitiatedShutdownBehaviorNode = XpathUtils.asNode("instanceInitiatedShutdownBehavior/value", node);
        instanceAttribute.setInstanceInitiatedShutdownBehavior(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(instanceInitiatedShutdownBehaviorNode));
        Node rootDeviceNameNode = XpathUtils.asNode("rootDeviceName/value", node);
        instanceAttribute.setRootDeviceName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(rootDeviceNameNode));
        NodeList blockDeviceMappingsNodes = XpathUtils.asNodeList("blockDeviceMapping/item", node);
        for (int blockDeviceMappingsIndex = 0; blockDeviceMappingsIndex < XpathUtils.nodeLength(blockDeviceMappingsNodes); ++blockDeviceMappingsIndex) {
            Node blockDeviceMappingsNode = blockDeviceMappingsNodes.item(blockDeviceMappingsIndex);
            instanceAttribute.getBlockDeviceMappings().add(new InstanceBlockDeviceMappingUnmarshaller().unmarshall(blockDeviceMappingsNode));
            blockDeviceMappingsNode.getParentNode().removeChild(blockDeviceMappingsNode);
        }
        return instanceAttribute;
    }
}

