/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.transform.BlockDeviceMappingUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateLaunchConfigurationRequestUnmarshaller
implements Unmarshaller<CreateLaunchConfigurationRequest, Node> {
    @Override
    public CreateLaunchConfigurationRequest unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        CreateLaunchConfigurationRequest createLaunchConfigurationRequest = new CreateLaunchConfigurationRequest();
        Node launchConfigurationNameNode = XpathUtils.asNode("LaunchConfigurationName", node);
        createLaunchConfigurationRequest.setLaunchConfigurationName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(launchConfigurationNameNode));
        Node imageIdNode = XpathUtils.asNode("ImageId", node);
        createLaunchConfigurationRequest.setImageId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(imageIdNode));
        Node keyNameNode = XpathUtils.asNode("KeyName", node);
        createLaunchConfigurationRequest.setKeyName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(keyNameNode));
        NodeList securityGroupsNodes = XpathUtils.asNodeList("SecurityGroups/member", node);
        for (int securityGroupsIndex = 0; securityGroupsIndex < XpathUtils.nodeLength(securityGroupsNodes); ++securityGroupsIndex) {
            Node securityGroupsNode = securityGroupsNodes.item(securityGroupsIndex);
            createLaunchConfigurationRequest.getSecurityGroups().add(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(securityGroupsNode));
            securityGroupsNode.getParentNode().removeChild(securityGroupsNode);
        }
        Node userDataNode = XpathUtils.asNode("UserData", node);
        createLaunchConfigurationRequest.setUserData(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(userDataNode));
        Node instanceTypeNode = XpathUtils.asNode("InstanceType", node);
        createLaunchConfigurationRequest.setInstanceType(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(instanceTypeNode));
        Node kernelIdNode = XpathUtils.asNode("KernelId", node);
        createLaunchConfigurationRequest.setKernelId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(kernelIdNode));
        Node ramdiskIdNode = XpathUtils.asNode("RamdiskId", node);
        createLaunchConfigurationRequest.setRamdiskId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(ramdiskIdNode));
        NodeList blockDeviceMappingsNodes = XpathUtils.asNodeList("BlockDeviceMappings/member", node);
        for (int blockDeviceMappingsIndex = 0; blockDeviceMappingsIndex < XpathUtils.nodeLength(blockDeviceMappingsNodes); ++blockDeviceMappingsIndex) {
            Node blockDeviceMappingsNode = blockDeviceMappingsNodes.item(blockDeviceMappingsIndex);
            createLaunchConfigurationRequest.getBlockDeviceMappings().add(new BlockDeviceMappingUnmarshaller().unmarshall(blockDeviceMappingsNode));
            blockDeviceMappingsNode.getParentNode().removeChild(blockDeviceMappingsNode);
        }
        return createLaunchConfigurationRequest;
    }
}

