/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateAutoScalingGroupRequestUnmarshaller
implements Unmarshaller<CreateAutoScalingGroupRequest, Node> {
    @Override
    public CreateAutoScalingGroupRequest unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        CreateAutoScalingGroupRequest createAutoScalingGroupRequest = new CreateAutoScalingGroupRequest();
        Node autoScalingGroupNameNode = XpathUtils.asNode("AutoScalingGroupName", node);
        createAutoScalingGroupRequest.setAutoScalingGroupName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(autoScalingGroupNameNode));
        Node launchConfigurationNameNode = XpathUtils.asNode("LaunchConfigurationName", node);
        createAutoScalingGroupRequest.setLaunchConfigurationName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(launchConfigurationNameNode));
        Node minSizeNode = XpathUtils.asNode("MinSize", node);
        createAutoScalingGroupRequest.setMinSize(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(minSizeNode));
        Node maxSizeNode = XpathUtils.asNode("MaxSize", node);
        createAutoScalingGroupRequest.setMaxSize(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(maxSizeNode));
        Node cooldownNode = XpathUtils.asNode("Cooldown", node);
        createAutoScalingGroupRequest.setCooldown(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(cooldownNode));
        NodeList availabilityZonesNodes = XpathUtils.asNodeList("AvailabilityZones/member", node);
        for (int availabilityZonesIndex = 0; availabilityZonesIndex < XpathUtils.nodeLength(availabilityZonesNodes); ++availabilityZonesIndex) {
            Node availabilityZonesNode = availabilityZonesNodes.item(availabilityZonesIndex);
            createAutoScalingGroupRequest.getAvailabilityZones().add(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(availabilityZonesNode));
            availabilityZonesNode.getParentNode().removeChild(availabilityZonesNode);
        }
        NodeList loadBalancerNamesNodes = XpathUtils.asNodeList("LoadBalancerNames/member", node);
        for (int loadBalancerNamesIndex = 0; loadBalancerNamesIndex < XpathUtils.nodeLength(loadBalancerNamesNodes); ++loadBalancerNamesIndex) {
            Node loadBalancerNamesNode = loadBalancerNamesNodes.item(loadBalancerNamesIndex);
            createAutoScalingGroupRequest.getLoadBalancerNames().add(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(loadBalancerNamesNode));
            loadBalancerNamesNode.getParentNode().removeChild(loadBalancerNamesNode);
        }
        return createAutoScalingGroupRequest;
    }
}

