/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.NamespaceRemovingInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.Date;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XpathUtils {
    private static XPathFactory xpathFactory = XPathFactory.newInstance();
    private static XPath xpath = xpathFactory.newXPath();
    private static DateUtils dateUtils = new DateUtils();
    private static Log log = LogFactory.getLog(XpathUtils.class);
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public static Document documentFrom(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        is = new NamespaceRemovingInputStream(is);
        Document doc = factory.newDocumentBuilder().parse(is);
        is.close();
        return doc;
    }

    public static Document documentFrom(String xml) throws SAXException, IOException, ParserConfigurationException {
        return XpathUtils.documentFrom(new ByteArrayInputStream(xml.getBytes()));
    }

    public static Document documentFrom(URL url) throws SAXException, IOException, ParserConfigurationException {
        return XpathUtils.documentFrom(url.openStream());
    }

    public static Double asDouble(String expression, Node node) throws XPathExpressionException {
        String doubleString = XpathUtils.evaluateAsString(expression, node);
        return doubleString == null ? null : Double.valueOf(Double.parseDouble(doubleString));
    }

    public static String asString(String expression, Node node) throws XPathExpressionException {
        return XpathUtils.evaluateAsString(expression, node);
    }

    public static Integer asInteger(String expression, Node node) throws XPathExpressionException {
        String intString = XpathUtils.evaluateAsString(expression, node);
        return intString == null ? null : Integer.valueOf(Integer.parseInt(intString));
    }

    public static Boolean asBoolean(String expression, Node node) throws XPathExpressionException {
        String booleanString = XpathUtils.evaluateAsString(expression, node);
        return booleanString == null ? null : Boolean.valueOf(Boolean.parseBoolean(booleanString));
    }

    public static Float asFloat(String expression, Node node) throws XPathExpressionException {
        String floatString = XpathUtils.evaluateAsString(expression, node);
        return floatString == null ? null : Float.valueOf(floatString);
    }

    public static Long asLong(String expression, Node node) throws XPathExpressionException {
        String longString = XpathUtils.evaluateAsString(expression, node);
        return longString == null ? null : Long.valueOf(Long.parseLong(longString));
    }

    public static Byte asByte(String expression, Node node) throws XPathExpressionException {
        String byteString = XpathUtils.evaluateAsString(expression, node);
        return byteString == null ? null : Byte.valueOf(byteString);
    }

    public static Date asDate(String expression, Node node) throws XPathExpressionException {
        String dateString = XpathUtils.evaluateAsString(expression, node);
        if (dateString == null) {
            return null;
        }
        try {
            return dateUtils.parseIso8601Date(dateString);
        }
        catch (ParseException e) {
            log.error((Object)("Unable to parse date '" + dateString + "':  " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static ByteBuffer asByteBuffer(String expression, Node node) throws XPathExpressionException {
        String base64EncodedString = XpathUtils.evaluateAsString(expression, node);
        if (base64EncodedString == null) {
            return null;
        }
        if (!XpathUtils.isEmpty(node)) {
            try {
                byte[] base64EncodedBytes = base64EncodedString.getBytes("UTF-8");
                byte[] decodedBytes = Base64.decodeBase64((byte[])base64EncodedBytes);
                return ByteBuffer.wrap(decodedBytes);
            }
            catch (UnsupportedEncodingException e) {
                throw new AmazonClientException("Unable to unmarshall XML data into a ByteBuffer", e);
            }
        }
        return null;
    }

    public static boolean isEmpty(Node node) {
        return node == null || !node.hasChildNodes();
    }

    public static Node asNode(String nodeName, Node node) throws XPathExpressionException {
        if (node == null) {
            return null;
        }
        return (Node)xpath.evaluate(nodeName, node, XPathConstants.NODE);
    }

    public static Node asNode(String expression, InputSource source) throws XPathExpressionException {
        return (Node)xpath.evaluate(expression, source, XPathConstants.NODE);
    }

    public static NodeList asNodeList(String expression, Node node) throws XPathExpressionException {
        if (node == null) {
            return null;
        }
        return (NodeList)xpath.evaluate(expression, node, XPathConstants.NODESET);
    }

    public static int nodeLength(NodeList list) {
        return list == null ? 0 : list.getLength();
    }

    private static String evaluateAsString(String expression, Node node) throws XPathExpressionException {
        if (XpathUtils.isEmpty(node)) {
            return null;
        }
        String s = xpath.evaluate(expression, node);
        if (s.trim().equals("")) {
            return null;
        }
        return s.trim();
    }
}

