/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class NamespaceRemovingInputStream
extends FilterInputStream {
    private byte[] lookAheadData = new byte[200];
    private boolean hasRemovedNamespace = false;
    private static final Pattern XMLNS_PATTERN = Pattern.compile("(xmlns\\s*=\\s*\".+?\").*", 32);

    public NamespaceRemovingInputStream(InputStream in) {
        super(new BufferedInputStream(in));
    }

    public int read() throws IOException {
        int b = this.in.read();
        if (b == 120 && !this.hasRemovedNamespace) {
            this.lookAheadData[0] = (byte)b;
            this.in.mark(this.lookAheadData.length);
            int bytesRead = this.in.read(this.lookAheadData, 1, this.lookAheadData.length - 1);
            this.in.reset();
            Matcher matcher = XMLNS_PATTERN.matcher(new String(this.lookAheadData, 0, bytesRead + 1));
            if (matcher.matches()) {
                String namespaceAttribute = matcher.group(1);
                for (int i = 0; i < namespaceAttribute.length() - 1; ++i) {
                    this.in.read();
                }
                b = this.in.read();
                this.hasRemovedNamespace = true;
            }
        }
        return b;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int j = this.read();
            if (j == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            b[i + off] = (byte)j;
        }
        return len;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

