/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.DBSecurityGroup;
import com.amazonaws.services.rds.model.transform.EC2SecurityGroupUnmarshaller;
import com.amazonaws.services.rds.model.transform.IPRangeUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBSecurityGroupUnmarshaller
implements Unmarshaller<DBSecurityGroup, Node> {
    @Override
    public DBSecurityGroup unmarshall(Node node) throws Exception {
        DBSecurityGroup dBSecurityGroup = new DBSecurityGroup();
        Node ownerIdNode = XpathUtils.asNode("OwnerId", node);
        dBSecurityGroup.setOwnerId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(ownerIdNode));
        Node dBSecurityGroupNameNode = XpathUtils.asNode("DBSecurityGroupName", node);
        dBSecurityGroup.setDBSecurityGroupName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(dBSecurityGroupNameNode));
        Node dBSecurityGroupDescriptionNode = XpathUtils.asNode("DBSecurityGroupDescription", node);
        dBSecurityGroup.setDBSecurityGroupDescription(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(dBSecurityGroupDescriptionNode));
        NodeList eC2SecurityGroupsNodes = XpathUtils.asNodeList("EC2SecurityGroups/EC2SecurityGroup", node);
        for (int eC2SecurityGroupsIndex = 0; eC2SecurityGroupsIndex < XpathUtils.nodeLength(eC2SecurityGroupsNodes); ++eC2SecurityGroupsIndex) {
            Node eC2SecurityGroupsNode = eC2SecurityGroupsNodes.item(eC2SecurityGroupsIndex);
            dBSecurityGroup.getEC2SecurityGroups().add(new EC2SecurityGroupUnmarshaller().unmarshall(eC2SecurityGroupsNode));
            eC2SecurityGroupsNode.getParentNode().removeChild(eC2SecurityGroupsNode);
        }
        NodeList iPRangesNodes = XpathUtils.asNodeList("IPRanges/IPRange", node);
        for (int iPRangesIndex = 0; iPRangesIndex < XpathUtils.nodeLength(iPRangesNodes); ++iPRangesIndex) {
            Node iPRangesNode = iPRangesNodes.item(iPRangesIndex);
            dBSecurityGroup.getIPRanges().add(new IPRangeUnmarshaller().unmarshall(iPRangesNode));
            iPRangesNode.getParentNode().removeChild(iPRangesNode);
        }
        return dBSecurityGroup;
    }
}

