/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.transform.InstanceBlockDeviceMappingUnmarshaller;
import com.amazonaws.services.ec2.model.transform.InstanceStateUnmarshaller;
import com.amazonaws.services.ec2.model.transform.MonitoringUnmarshaller;
import com.amazonaws.services.ec2.model.transform.PlacementUnmarshaller;
import com.amazonaws.services.ec2.model.transform.ProductCodeUnmarshaller;
import com.amazonaws.services.ec2.model.transform.StateReasonUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceUnmarshaller
implements Unmarshaller<Instance, Node> {
    @Override
    public Instance unmarshall(Node node) throws Exception {
        Instance instance = new Instance();
        Node instanceIdNode = XpathUtils.asNode("instanceId", node);
        instance.setInstanceId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(instanceIdNode));
        Node imageIdNode = XpathUtils.asNode("imageId", node);
        instance.setImageId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(imageIdNode));
        Node stateNode = XpathUtils.asNode("instanceState", node);
        instance.setState(new InstanceStateUnmarshaller().unmarshall(stateNode));
        Node privateDnsNameNode = XpathUtils.asNode("privateDnsName", node);
        instance.setPrivateDnsName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(privateDnsNameNode));
        Node publicDnsNameNode = XpathUtils.asNode("dnsName", node);
        instance.setPublicDnsName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(publicDnsNameNode));
        Node stateTransitionReasonNode = XpathUtils.asNode("reason", node);
        instance.setStateTransitionReason(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(stateTransitionReasonNode));
        Node keyNameNode = XpathUtils.asNode("keyName", node);
        instance.setKeyName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(keyNameNode));
        Node amiLaunchIndexNode = XpathUtils.asNode("amiLaunchIndex", node);
        instance.setAmiLaunchIndex(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(amiLaunchIndexNode));
        NodeList productCodesNodes = XpathUtils.asNodeList("productCodes/item", node);
        for (int productCodesIndex = 0; productCodesIndex < XpathUtils.nodeLength(productCodesNodes); ++productCodesIndex) {
            Node productCodesNode = productCodesNodes.item(productCodesIndex);
            instance.getProductCodes().add(new ProductCodeUnmarshaller().unmarshall(productCodesNode));
            productCodesNode.getParentNode().removeChild(productCodesNode);
        }
        Node instanceTypeNode = XpathUtils.asNode("instanceType", node);
        instance.setInstanceType(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(instanceTypeNode));
        Node launchTimeNode = XpathUtils.asNode("launchTime", node);
        instance.setLaunchTime(new SimpleTypeUnmarshallers.DateUnmarshaller().unmarshall(launchTimeNode));
        Node placementNode = XpathUtils.asNode("placement", node);
        instance.setPlacement(new PlacementUnmarshaller().unmarshall(placementNode));
        Node kernelIdNode = XpathUtils.asNode("kernelId", node);
        instance.setKernelId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(kernelIdNode));
        Node ramdiskIdNode = XpathUtils.asNode("ramdiskId", node);
        instance.setRamdiskId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(ramdiskIdNode));
        Node platformNode = XpathUtils.asNode("platform", node);
        instance.setPlatform(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(platformNode));
        Node monitoringNode = XpathUtils.asNode("monitoring", node);
        instance.setMonitoring(new MonitoringUnmarshaller().unmarshall(monitoringNode));
        Node subnetIdNode = XpathUtils.asNode("subnetId", node);
        instance.setSubnetId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(subnetIdNode));
        Node vpcIdNode = XpathUtils.asNode("vpcId", node);
        instance.setVpcId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(vpcIdNode));
        Node privateIpAddressNode = XpathUtils.asNode("privateIpAddress", node);
        instance.setPrivateIpAddress(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(privateIpAddressNode));
        Node publicIpAddressNode = XpathUtils.asNode("ipAddress", node);
        instance.setPublicIpAddress(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(publicIpAddressNode));
        Node stateReasonNode = XpathUtils.asNode("stateReason", node);
        instance.setStateReason(new StateReasonUnmarshaller().unmarshall(stateReasonNode));
        Node architectureNode = XpathUtils.asNode("architecture", node);
        instance.setArchitecture(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(architectureNode));
        Node rootDeviceTypeNode = XpathUtils.asNode("rootDeviceType", node);
        instance.setRootDeviceType(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(rootDeviceTypeNode));
        Node rootDeviceNameNode = XpathUtils.asNode("rootDeviceName", node);
        instance.setRootDeviceName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(rootDeviceNameNode));
        NodeList blockDeviceMappingsNodes = XpathUtils.asNodeList("blockDeviceMapping/item", node);
        for (int blockDeviceMappingsIndex = 0; blockDeviceMappingsIndex < XpathUtils.nodeLength(blockDeviceMappingsNodes); ++blockDeviceMappingsIndex) {
            Node blockDeviceMappingsNode = blockDeviceMappingsNodes.item(blockDeviceMappingsIndex);
            instance.getBlockDeviceMappings().add(new InstanceBlockDeviceMappingUnmarshaller().unmarshall(blockDeviceMappingsNode));
            blockDeviceMappingsNode.getParentNode().removeChild(blockDeviceMappingsNode);
        }
        return instance;
    }
}

