/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.ResponseMetadata;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.transform.ResponseMetadataUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResponseHandler<T>
implements HttpResponseHandler<ResponseMetadata<T>> {
    private String responseElementPath;
    private Unmarshaller<T, Node> responseUnmarshaller;
    private String requestIdPath = null;
    private static final Log log = LogFactory.getLog((String)"com.amazonaws.request");

    public DefaultResponseHandler(Unmarshaller<T, Node> responseUnmarshaller, String responseElementPath) {
        this.responseUnmarshaller = responseUnmarshaller;
        this.responseElementPath = responseElementPath;
    }

    public DefaultResponseHandler(Unmarshaller<T, Node> responseUnmarshaller, String responseElementPath, String requestIdPath) {
        this(responseUnmarshaller, responseElementPath);
        this.requestIdPath = requestIdPath;
    }

    @Override
    public ResponseMetadata<T> handle(HttpResponse response) throws Exception {
        log.trace((Object)"Beginning to parse service response XML");
        Document document = XpathUtils.documentFrom(response.getContent());
        log.trace((Object)"Done parsing service response XML");
        ResponseMetadataUnmarshaller responseMetadataUnmarshaller = new ResponseMetadataUnmarshaller();
        if (this.requestIdPath != null) {
            responseMetadataUnmarshaller.setRequestIdPath(this.requestIdPath);
        }
        ResponseMetadata<T> responseMetadata = responseMetadataUnmarshaller.unmarshall(document);
        if (this.responseUnmarshaller != null) {
            Node node = XpathUtils.asNode(this.responseElementPath, document);
            T result = this.responseUnmarshaller.unmarshall(node);
            responseMetadata.setResult(result);
        }
        return responseMetadata;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

