/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.xray.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetInsight" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetInsightRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.
     * </p>
     */
    private String insightId;

    /**
     * <p>
     * The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.
     * </p>
     * 
     * @param insightId
     *        The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.
     */

    public void setInsightId(String insightId) {
        this.insightId = insightId;
    }

    /**
     * <p>
     * The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.
     * </p>
     * 
     * @return The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.
     */

    public String getInsightId() {
        return this.insightId;
    }

    /**
     * <p>
     * The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.
     * </p>
     * 
     * @param insightId
     *        The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetInsightRequest withInsightId(String insightId) {
        setInsightId(insightId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getInsightId() != null)
            sb.append("InsightId: ").append(getInsightId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetInsightRequest == false)
            return false;
        GetInsightRequest other = (GetInsightRequest) obj;
        if (other.getInsightId() == null ^ this.getInsightId() == null)
            return false;
        if (other.getInsightId() != null && other.getInsightId().equals(this.getInsightId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getInsightId() == null) ? 0 : getInsightId().hashCode());
        return hashCode;
    }

    @Override
    public GetInsightRequest clone() {
        return (GetInsightRequest) super.clone();
    }

}
