/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.xray.model.InsightsConfiguration;
import com.amazonaws.services.xray.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String groupName;
    private String filterExpression;
    private InsightsConfiguration insightsConfiguration;
    private List<Tag> tags;

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public CreateGroupRequest withGroupName(String groupName) {
        this.setGroupName(groupName);
        return this;
    }

    public void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public CreateGroupRequest withFilterExpression(String filterExpression) {
        this.setFilterExpression(filterExpression);
        return this;
    }

    public void setInsightsConfiguration(InsightsConfiguration insightsConfiguration) {
        this.insightsConfiguration = insightsConfiguration;
    }

    public InsightsConfiguration getInsightsConfiguration() {
        return this.insightsConfiguration;
    }

    public CreateGroupRequest withInsightsConfiguration(InsightsConfiguration insightsConfiguration) {
        this.setInsightsConfiguration(insightsConfiguration);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateGroupRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateGroupRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroupName() != null) {
            sb.append("GroupName: ").append(this.getGroupName()).append(",");
        }
        if (this.getFilterExpression() != null) {
            sb.append("FilterExpression: ").append(this.getFilterExpression()).append(",");
        }
        if (this.getInsightsConfiguration() != null) {
            sb.append("InsightsConfiguration: ").append(this.getInsightsConfiguration()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupRequest)) {
            return false;
        }
        CreateGroupRequest other = (CreateGroupRequest)obj;
        if (other.getGroupName() == null ^ this.getGroupName() == null) {
            return false;
        }
        if (other.getGroupName() != null && !other.getGroupName().equals(this.getGroupName())) {
            return false;
        }
        if (other.getFilterExpression() == null ^ this.getFilterExpression() == null) {
            return false;
        }
        if (other.getFilterExpression() != null && !other.getFilterExpression().equals(this.getFilterExpression())) {
            return false;
        }
        if (other.getInsightsConfiguration() == null ^ this.getInsightsConfiguration() == null) {
            return false;
        }
        if (other.getInsightsConfiguration() != null && !other.getInsightsConfiguration().equals(this.getInsightsConfiguration())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroupName() == null ? 0 : this.getGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getFilterExpression() == null ? 0 : this.getFilterExpression().hashCode());
        hashCode = 31 * hashCode + (this.getInsightsConfiguration() == null ? 0 : this.getInsightsConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateGroupRequest clone() {
        return (CreateGroupRequest)super.clone();
    }
}

