/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.xray.model.AnomalousService;
import com.amazonaws.services.xray.model.RequestImpactStatistics;
import com.amazonaws.services.xray.model.transform.InsightEventMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class InsightEvent
implements Serializable,
Cloneable,
StructuredPojo {
    private String summary;
    private Date eventTime;
    private RequestImpactStatistics clientRequestImpactStatistics;
    private RequestImpactStatistics rootCauseServiceRequestImpactStatistics;
    private List<AnomalousService> topAnomalousServices;

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getSummary() {
        return this.summary;
    }

    public InsightEvent withSummary(String summary) {
        this.setSummary(summary);
        return this;
    }

    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public InsightEvent withEventTime(Date eventTime) {
        this.setEventTime(eventTime);
        return this;
    }

    public void setClientRequestImpactStatistics(RequestImpactStatistics clientRequestImpactStatistics) {
        this.clientRequestImpactStatistics = clientRequestImpactStatistics;
    }

    public RequestImpactStatistics getClientRequestImpactStatistics() {
        return this.clientRequestImpactStatistics;
    }

    public InsightEvent withClientRequestImpactStatistics(RequestImpactStatistics clientRequestImpactStatistics) {
        this.setClientRequestImpactStatistics(clientRequestImpactStatistics);
        return this;
    }

    public void setRootCauseServiceRequestImpactStatistics(RequestImpactStatistics rootCauseServiceRequestImpactStatistics) {
        this.rootCauseServiceRequestImpactStatistics = rootCauseServiceRequestImpactStatistics;
    }

    public RequestImpactStatistics getRootCauseServiceRequestImpactStatistics() {
        return this.rootCauseServiceRequestImpactStatistics;
    }

    public InsightEvent withRootCauseServiceRequestImpactStatistics(RequestImpactStatistics rootCauseServiceRequestImpactStatistics) {
        this.setRootCauseServiceRequestImpactStatistics(rootCauseServiceRequestImpactStatistics);
        return this;
    }

    public List<AnomalousService> getTopAnomalousServices() {
        return this.topAnomalousServices;
    }

    public void setTopAnomalousServices(Collection<AnomalousService> topAnomalousServices) {
        if (topAnomalousServices == null) {
            this.topAnomalousServices = null;
            return;
        }
        this.topAnomalousServices = new ArrayList<AnomalousService>(topAnomalousServices);
    }

    public InsightEvent withTopAnomalousServices(AnomalousService ... topAnomalousServices) {
        if (this.topAnomalousServices == null) {
            this.setTopAnomalousServices(new ArrayList<AnomalousService>(topAnomalousServices.length));
        }
        for (AnomalousService ele : topAnomalousServices) {
            this.topAnomalousServices.add(ele);
        }
        return this;
    }

    public InsightEvent withTopAnomalousServices(Collection<AnomalousService> topAnomalousServices) {
        this.setTopAnomalousServices(topAnomalousServices);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSummary() != null) {
            sb.append("Summary: ").append(this.getSummary()).append(",");
        }
        if (this.getEventTime() != null) {
            sb.append("EventTime: ").append(this.getEventTime()).append(",");
        }
        if (this.getClientRequestImpactStatistics() != null) {
            sb.append("ClientRequestImpactStatistics: ").append(this.getClientRequestImpactStatistics()).append(",");
        }
        if (this.getRootCauseServiceRequestImpactStatistics() != null) {
            sb.append("RootCauseServiceRequestImpactStatistics: ").append(this.getRootCauseServiceRequestImpactStatistics()).append(",");
        }
        if (this.getTopAnomalousServices() != null) {
            sb.append("TopAnomalousServices: ").append(this.getTopAnomalousServices());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightEvent)) {
            return false;
        }
        InsightEvent other = (InsightEvent)obj;
        if (other.getSummary() == null ^ this.getSummary() == null) {
            return false;
        }
        if (other.getSummary() != null && !other.getSummary().equals(this.getSummary())) {
            return false;
        }
        if (other.getEventTime() == null ^ this.getEventTime() == null) {
            return false;
        }
        if (other.getEventTime() != null && !other.getEventTime().equals(this.getEventTime())) {
            return false;
        }
        if (other.getClientRequestImpactStatistics() == null ^ this.getClientRequestImpactStatistics() == null) {
            return false;
        }
        if (other.getClientRequestImpactStatistics() != null && !other.getClientRequestImpactStatistics().equals(this.getClientRequestImpactStatistics())) {
            return false;
        }
        if (other.getRootCauseServiceRequestImpactStatistics() == null ^ this.getRootCauseServiceRequestImpactStatistics() == null) {
            return false;
        }
        if (other.getRootCauseServiceRequestImpactStatistics() != null && !other.getRootCauseServiceRequestImpactStatistics().equals(this.getRootCauseServiceRequestImpactStatistics())) {
            return false;
        }
        if (other.getTopAnomalousServices() == null ^ this.getTopAnomalousServices() == null) {
            return false;
        }
        return other.getTopAnomalousServices() == null || other.getTopAnomalousServices().equals(this.getTopAnomalousServices());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSummary() == null ? 0 : this.getSummary().hashCode());
        hashCode = 31 * hashCode + (this.getEventTime() == null ? 0 : this.getEventTime().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestImpactStatistics() == null ? 0 : this.getClientRequestImpactStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getRootCauseServiceRequestImpactStatistics() == null ? 0 : this.getRootCauseServiceRequestImpactStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getTopAnomalousServices() == null ? 0 : this.getTopAnomalousServices().hashCode());
        return hashCode;
    }

    public InsightEvent clone() {
        try {
            return (InsightEvent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InsightEventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

