/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.xray.model.SamplingRule;
import com.amazonaws.services.xray.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateSamplingRuleRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SamplingRule samplingRule;
    private List<Tag> tags;

    public void setSamplingRule(SamplingRule samplingRule) {
        this.samplingRule = samplingRule;
    }

    public SamplingRule getSamplingRule() {
        return this.samplingRule;
    }

    public CreateSamplingRuleRequest withSamplingRule(SamplingRule samplingRule) {
        this.setSamplingRule(samplingRule);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateSamplingRuleRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateSamplingRuleRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSamplingRule() != null) {
            sb.append("SamplingRule: ").append(this.getSamplingRule()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSamplingRuleRequest)) {
            return false;
        }
        CreateSamplingRuleRequest other = (CreateSamplingRuleRequest)obj;
        if (other.getSamplingRule() == null ^ this.getSamplingRule() == null) {
            return false;
        }
        if (other.getSamplingRule() != null && !other.getSamplingRule().equals(this.getSamplingRule())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSamplingRule() == null ? 0 : this.getSamplingRule().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateSamplingRuleRequest clone() {
        return (CreateSamplingRuleRequest)super.clone();
    }
}

