/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.ServiceStatistics;
import com.amazonaws.services.xray.model.transform.ErrorStatisticsJsonMarshaller;
import com.amazonaws.services.xray.model.transform.FaultStatisticsJsonMarshaller;

public class ServiceStatisticsJsonMarshaller {
    private static ServiceStatisticsJsonMarshaller instance;

    public void marshall(ServiceStatistics serviceStatistics, StructuredJsonGenerator jsonGenerator) {
        if (serviceStatistics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (serviceStatistics.getOkCount() != null) {
                jsonGenerator.writeFieldName("OkCount").writeValue(serviceStatistics.getOkCount().longValue());
            }
            if (serviceStatistics.getErrorStatistics() != null) {
                jsonGenerator.writeFieldName("ErrorStatistics");
                ErrorStatisticsJsonMarshaller.getInstance().marshall(serviceStatistics.getErrorStatistics(), jsonGenerator);
            }
            if (serviceStatistics.getFaultStatistics() != null) {
                jsonGenerator.writeFieldName("FaultStatistics");
                FaultStatisticsJsonMarshaller.getInstance().marshall(serviceStatistics.getFaultStatistics(), jsonGenerator);
            }
            if (serviceStatistics.getTotalCount() != null) {
                jsonGenerator.writeFieldName("TotalCount").writeValue(serviceStatistics.getTotalCount().longValue());
            }
            if (serviceStatistics.getTotalResponseTime() != null) {
                jsonGenerator.writeFieldName("TotalResponseTime").writeValue(serviceStatistics.getTotalResponseTime().doubleValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ServiceStatisticsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ServiceStatisticsJsonMarshaller();
        }
        return instance;
    }
}

