/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.EdgeStatistics;
import com.amazonaws.services.xray.model.transform.ErrorStatisticsJsonMarshaller;
import com.amazonaws.services.xray.model.transform.FaultStatisticsJsonMarshaller;

public class EdgeStatisticsJsonMarshaller {
    private static EdgeStatisticsJsonMarshaller instance;

    public void marshall(EdgeStatistics edgeStatistics, StructuredJsonGenerator jsonGenerator) {
        if (edgeStatistics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (edgeStatistics.getOkCount() != null) {
                jsonGenerator.writeFieldName("OkCount").writeValue(edgeStatistics.getOkCount().longValue());
            }
            if (edgeStatistics.getErrorStatistics() != null) {
                jsonGenerator.writeFieldName("ErrorStatistics");
                ErrorStatisticsJsonMarshaller.getInstance().marshall(edgeStatistics.getErrorStatistics(), jsonGenerator);
            }
            if (edgeStatistics.getFaultStatistics() != null) {
                jsonGenerator.writeFieldName("FaultStatistics");
                FaultStatisticsJsonMarshaller.getInstance().marshall(edgeStatistics.getFaultStatistics(), jsonGenerator);
            }
            if (edgeStatistics.getTotalCount() != null) {
                jsonGenerator.writeFieldName("TotalCount").writeValue(edgeStatistics.getTotalCount().longValue());
            }
            if (edgeStatistics.getTotalResponseTime() != null) {
                jsonGenerator.writeFieldName("TotalResponseTime").writeValue(edgeStatistics.getTotalResponseTime().doubleValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EdgeStatisticsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EdgeStatisticsJsonMarshaller();
        }
        return instance;
    }
}

