/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.ServiceId;
import java.util.List;

public class ServiceIdJsonMarshaller {
    private static ServiceIdJsonMarshaller instance;

    public void marshall(ServiceId serviceId, StructuredJsonGenerator jsonGenerator) {
        if (serviceId == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> namesList;
            jsonGenerator.writeStartObject();
            if (serviceId.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(serviceId.getName());
            }
            if ((namesList = serviceId.getNames()) != null) {
                jsonGenerator.writeFieldName("Names");
                jsonGenerator.writeStartArray();
                for (String namesListValue : namesList) {
                    if (namesListValue == null) continue;
                    jsonGenerator.writeValue(namesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (serviceId.getAccountId() != null) {
                jsonGenerator.writeFieldName("AccountId").writeValue(serviceId.getAccountId());
            }
            if (serviceId.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(serviceId.getType());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ServiceIdJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ServiceIdJsonMarshaller();
        }
        return instance;
    }
}

