/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.GetTraceGraphRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class GetTraceGraphRequestMarshaller
implements Marshaller<Request<GetTraceGraphRequest>, GetTraceGraphRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetTraceGraphRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetTraceGraphRequest> marshall(GetTraceGraphRequest getTraceGraphRequest) {
        if (getTraceGraphRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getTraceGraphRequest, "AWSXRay");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/TraceGraph";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> traceIdsList = getTraceGraphRequest.getTraceIds();
            if (traceIdsList != null) {
                jsonGenerator.writeFieldName("TraceIds");
                jsonGenerator.writeStartArray();
                for (String traceIdsListValue : traceIdsList) {
                    if (traceIdsListValue == null) continue;
                    jsonGenerator.writeValue(traceIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (getTraceGraphRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(getTraceGraphRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

