/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.AnnotationValue;

public class AnnotationValueJsonMarshaller {
    private static AnnotationValueJsonMarshaller instance;

    public void marshall(AnnotationValue annotationValue, StructuredJsonGenerator jsonGenerator) {
        if (annotationValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (annotationValue.getNumberValue() != null) {
                jsonGenerator.writeFieldName("NumberValue").writeValue(annotationValue.getNumberValue().doubleValue());
            }
            if (annotationValue.getBooleanValue() != null) {
                jsonGenerator.writeFieldName("BooleanValue").writeValue(annotationValue.getBooleanValue().booleanValue());
            }
            if (annotationValue.getStringValue() != null) {
                jsonGenerator.writeFieldName("StringValue").writeValue(annotationValue.getStringValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AnnotationValueJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AnnotationValueJsonMarshaller();
        }
        return instance;
    }
}

