/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.GetServiceGraphRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetServiceGraphRequestMarshaller
implements Marshaller<Request<GetServiceGraphRequest>, GetServiceGraphRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetServiceGraphRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetServiceGraphRequest> marshall(GetServiceGraphRequest getServiceGraphRequest) {
        if (getServiceGraphRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getServiceGraphRequest, "AWSXRay");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/ServiceGraph";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getServiceGraphRequest.getStartTime() != null) {
                jsonGenerator.writeFieldName("StartTime").writeValue(getServiceGraphRequest.getStartTime());
            }
            if (getServiceGraphRequest.getEndTime() != null) {
                jsonGenerator.writeFieldName("EndTime").writeValue(getServiceGraphRequest.getEndTime());
            }
            if (getServiceGraphRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(getServiceGraphRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

