/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.workspaces;

import javax.annotation.Generated;

import com.amazonaws.services.workspaces.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonWorkspaces}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonWorkspaces implements AmazonWorkspaces {

    protected AbstractAmazonWorkspaces() {
    }

    @Override
    public void setEndpoint(String endpoint) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void setRegion(com.amazonaws.regions.Region region) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AcceptAccountLinkInvitationResult acceptAccountLinkInvitation(AcceptAccountLinkInvitationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateConnectionAliasResult associateConnectionAlias(AssociateConnectionAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateIpGroupsResult associateIpGroups(AssociateIpGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateWorkspaceApplicationResult associateWorkspaceApplication(AssociateWorkspaceApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AuthorizeIpRulesResult authorizeIpRules(AuthorizeIpRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CopyWorkspaceImageResult copyWorkspaceImage(CopyWorkspaceImageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAccountLinkInvitationResult createAccountLinkInvitation(CreateAccountLinkInvitationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateConnectClientAddInResult createConnectClientAddIn(CreateConnectClientAddInRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateConnectionAliasResult createConnectionAlias(CreateConnectionAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIpGroupResult createIpGroup(CreateIpGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateStandbyWorkspacesResult createStandbyWorkspaces(CreateStandbyWorkspacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTagsResult createTags(CreateTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateUpdatedWorkspaceImageResult createUpdatedWorkspaceImage(CreateUpdatedWorkspaceImageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkspaceBundleResult createWorkspaceBundle(CreateWorkspaceBundleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkspaceImageResult createWorkspaceImage(CreateWorkspaceImageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkspacesResult createWorkspaces(CreateWorkspacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkspacesPoolResult createWorkspacesPool(CreateWorkspacesPoolRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAccountLinkInvitationResult deleteAccountLinkInvitation(DeleteAccountLinkInvitationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteClientBrandingResult deleteClientBranding(DeleteClientBrandingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConnectClientAddInResult deleteConnectClientAddIn(DeleteConnectClientAddInRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConnectionAliasResult deleteConnectionAlias(DeleteConnectionAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIpGroupResult deleteIpGroup(DeleteIpGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTagsResult deleteTags(DeleteTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkspaceBundleResult deleteWorkspaceBundle(DeleteWorkspaceBundleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkspaceImageResult deleteWorkspaceImage(DeleteWorkspaceImageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeployWorkspaceApplicationsResult deployWorkspaceApplications(DeployWorkspaceApplicationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterWorkspaceDirectoryResult deregisterWorkspaceDirectory(DeregisterWorkspaceDirectoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAccountResult describeAccount(DescribeAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAccountModificationsResult describeAccountModifications(DescribeAccountModificationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeApplicationAssociationsResult describeApplicationAssociations(DescribeApplicationAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeApplicationsResult describeApplications(DescribeApplicationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeBundleAssociationsResult describeBundleAssociations(DescribeBundleAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeClientBrandingResult describeClientBranding(DescribeClientBrandingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeClientPropertiesResult describeClientProperties(DescribeClientPropertiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeConnectClientAddInsResult describeConnectClientAddIns(DescribeConnectClientAddInsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeConnectionAliasPermissionsResult describeConnectionAliasPermissions(DescribeConnectionAliasPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeConnectionAliasesResult describeConnectionAliases(DescribeConnectionAliasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeImageAssociationsResult describeImageAssociations(DescribeImageAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeIpGroupsResult describeIpGroups(DescribeIpGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTagsResult describeTags(DescribeTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeWorkspaceAssociationsResult describeWorkspaceAssociations(DescribeWorkspaceAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeWorkspaceBundlesResult describeWorkspaceBundles(DescribeWorkspaceBundlesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeWorkspaceBundlesResult describeWorkspaceBundles() {
        return describeWorkspaceBundles(new DescribeWorkspaceBundlesRequest());
    }

    @Override
    public DescribeWorkspaceDirectoriesResult describeWorkspaceDirectories(DescribeWorkspaceDirectoriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeWorkspaceDirectoriesResult describeWorkspaceDirectories() {
        return describeWorkspaceDirectories(new DescribeWorkspaceDirectoriesRequest());
    }

    @Override
    public DescribeWorkspaceImagePermissionsResult describeWorkspaceImagePermissions(DescribeWorkspaceImagePermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeWorkspaceImagesResult describeWorkspaceImages(DescribeWorkspaceImagesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeWorkspaceSnapshotsResult describeWorkspaceSnapshots(DescribeWorkspaceSnapshotsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeWorkspacesResult describeWorkspaces(DescribeWorkspacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeWorkspacesResult describeWorkspaces() {
        return describeWorkspaces(new DescribeWorkspacesRequest());
    }

    @Override
    public DescribeWorkspacesConnectionStatusResult describeWorkspacesConnectionStatus(DescribeWorkspacesConnectionStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeWorkspacesPoolSessionsResult describeWorkspacesPoolSessions(DescribeWorkspacesPoolSessionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeWorkspacesPoolsResult describeWorkspacesPools(DescribeWorkspacesPoolsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateConnectionAliasResult disassociateConnectionAlias(DisassociateConnectionAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateIpGroupsResult disassociateIpGroups(DisassociateIpGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateWorkspaceApplicationResult disassociateWorkspaceApplication(DisassociateWorkspaceApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAccountLinkResult getAccountLink(GetAccountLinkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ImportClientBrandingResult importClientBranding(ImportClientBrandingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ImportWorkspaceImageResult importWorkspaceImage(ImportWorkspaceImageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccountLinksResult listAccountLinks(ListAccountLinksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAvailableManagementCidrRangesResult listAvailableManagementCidrRanges(ListAvailableManagementCidrRangesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public MigrateWorkspaceResult migrateWorkspace(MigrateWorkspaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyAccountResult modifyAccount(ModifyAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyCertificateBasedAuthPropertiesResult modifyCertificateBasedAuthProperties(ModifyCertificateBasedAuthPropertiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyClientPropertiesResult modifyClientProperties(ModifyClientPropertiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifySamlPropertiesResult modifySamlProperties(ModifySamlPropertiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifySelfservicePermissionsResult modifySelfservicePermissions(ModifySelfservicePermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyStreamingPropertiesResult modifyStreamingProperties(ModifyStreamingPropertiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyWorkspaceAccessPropertiesResult modifyWorkspaceAccessProperties(ModifyWorkspaceAccessPropertiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyWorkspaceCreationPropertiesResult modifyWorkspaceCreationProperties(ModifyWorkspaceCreationPropertiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyWorkspacePropertiesResult modifyWorkspaceProperties(ModifyWorkspacePropertiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyWorkspaceStateResult modifyWorkspaceState(ModifyWorkspaceStateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RebootWorkspacesResult rebootWorkspaces(RebootWorkspacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RebuildWorkspacesResult rebuildWorkspaces(RebuildWorkspacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterWorkspaceDirectoryResult registerWorkspaceDirectory(RegisterWorkspaceDirectoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RejectAccountLinkInvitationResult rejectAccountLinkInvitation(RejectAccountLinkInvitationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RestoreWorkspaceResult restoreWorkspace(RestoreWorkspaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RevokeIpRulesResult revokeIpRules(RevokeIpRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartWorkspacesResult startWorkspaces(StartWorkspacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartWorkspacesPoolResult startWorkspacesPool(StartWorkspacesPoolRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopWorkspacesResult stopWorkspaces(StopWorkspacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopWorkspacesPoolResult stopWorkspacesPool(StopWorkspacesPoolRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TerminateWorkspacesResult terminateWorkspaces(TerminateWorkspacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TerminateWorkspacesPoolResult terminateWorkspacesPool(TerminateWorkspacesPoolRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TerminateWorkspacesPoolSessionResult terminateWorkspacesPoolSession(TerminateWorkspacesPoolSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConnectClientAddInResult updateConnectClientAddIn(UpdateConnectClientAddInRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConnectionAliasPermissionResult updateConnectionAliasPermission(UpdateConnectionAliasPermissionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRulesOfIpGroupResult updateRulesOfIpGroup(UpdateRulesOfIpGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkspaceBundleResult updateWorkspaceBundle(UpdateWorkspaceBundleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkspaceImagePermissionResult updateWorkspaceImagePermission(UpdateWorkspaceImagePermissionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkspacesPoolResult updateWorkspacesPool(UpdateWorkspacesPoolRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
