/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.workspaces.model.StartRequest;
import com.amazonaws.services.workspaces.model.StartWorkspacesRequest;
import com.amazonaws.services.workspaces.model.transform.StartRequestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class StartWorkspacesRequestMarshaller
implements Marshaller<Request<StartWorkspacesRequest>, StartWorkspacesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public StartWorkspacesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<StartWorkspacesRequest> marshall(StartWorkspacesRequest startWorkspacesRequest) {
        if (startWorkspacesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)startWorkspacesRequest, "AmazonWorkspaces");
        request.addHeader("X-Amz-Target", "WorkspacesService.StartWorkspaces");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList startWorkspaceRequestsList = (SdkInternalList)startWorkspacesRequest.getStartWorkspaceRequests();
            if (!startWorkspaceRequestsList.isEmpty() || !startWorkspaceRequestsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("StartWorkspaceRequests");
                jsonGenerator.writeStartArray();
                for (StartRequest startWorkspaceRequestsListValue : startWorkspaceRequestsList) {
                    if (startWorkspaceRequestsListValue == null) continue;
                    StartRequestJsonMarshaller.getInstance().marshall(startWorkspaceRequestsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

