/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.workspaces.model.TerminateRequest;
import com.amazonaws.services.workspaces.model.TerminateWorkspacesRequest;
import com.amazonaws.services.workspaces.model.transform.TerminateRequestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class TerminateWorkspacesRequestMarshaller
implements Marshaller<Request<TerminateWorkspacesRequest>, TerminateWorkspacesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public TerminateWorkspacesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<TerminateWorkspacesRequest> marshall(TerminateWorkspacesRequest terminateWorkspacesRequest) {
        if (terminateWorkspacesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)terminateWorkspacesRequest, "AmazonWorkspaces");
        request.addHeader("X-Amz-Target", "WorkspacesService.TerminateWorkspaces");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList terminateWorkspaceRequestsList = (SdkInternalList)terminateWorkspacesRequest.getTerminateWorkspaceRequests();
            if (!terminateWorkspaceRequestsList.isEmpty() || !terminateWorkspaceRequestsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("TerminateWorkspaceRequests");
                jsonGenerator.writeStartArray();
                for (TerminateRequest terminateWorkspaceRequestsListValue : terminateWorkspaceRequestsList) {
                    if (terminateWorkspaceRequestsListValue == null) continue;
                    TerminateRequestJsonMarshaller.getInstance().marshall(terminateWorkspaceRequestsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

