/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceDirectoriesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeWorkspaceDirectoriesRequestMarshaller
implements Marshaller<Request<DescribeWorkspaceDirectoriesRequest>, DescribeWorkspaceDirectoriesRequest> {
    public Request<DescribeWorkspaceDirectoriesRequest> marshall(DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) {
        if (describeWorkspaceDirectoriesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeWorkspaceDirectoriesRequest, "AmazonWorkspaces");
        request.addHeader("X-Amz-Target", "WorkspacesService.DescribeWorkspaceDirectories");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            SdkInternalList directoryIdsList = (SdkInternalList)describeWorkspaceDirectoriesRequest.getDirectoryIds();
            if (!directoryIdsList.isEmpty() || !directoryIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("DirectoryIds");
                jsonGenerator.writeStartArray();
                for (String directoryIdsListValue : directoryIdsList) {
                    if (directoryIdsListValue == null) continue;
                    jsonGenerator.writeValue(directoryIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeWorkspaceDirectoriesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeWorkspaceDirectoriesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

