/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.workspaces.model.RebootRequest;
import com.amazonaws.services.workspaces.model.RebootWorkspacesRequest;
import com.amazonaws.services.workspaces.model.transform.RebootRequestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RebootWorkspacesRequestMarshaller
implements Marshaller<Request<RebootWorkspacesRequest>, RebootWorkspacesRequest> {
    public Request<RebootWorkspacesRequest> marshall(RebootWorkspacesRequest rebootWorkspacesRequest) {
        if (rebootWorkspacesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)rebootWorkspacesRequest, "AmazonWorkspaces");
        request.addHeader("X-Amz-Target", "WorkspacesService.RebootWorkspaces");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList rebootWorkspaceRequestsList = (SdkInternalList)rebootWorkspacesRequest.getRebootWorkspaceRequests();
            if (!rebootWorkspaceRequestsList.isEmpty() || !rebootWorkspaceRequestsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("RebootWorkspaceRequests");
                jsonGenerator.writeStartArray();
                for (RebootRequest rebootWorkspaceRequestsListValue : rebootWorkspaceRequestsList) {
                    if (rebootWorkspaceRequestsListValue == null) continue;
                    RebootRequestJsonMarshaller.getInstance().marshall(rebootWorkspaceRequestsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

