/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workmail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.workmail.model.AccessEffect;
import com.amazonaws.services.workmail.model.transform.ImpersonationRuleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImpersonationRule
implements Serializable,
Cloneable,
StructuredPojo {
    private String impersonationRuleId;
    private String name;
    private String description;
    private String effect;
    private List<String> targetUsers;
    private List<String> notTargetUsers;

    public void setImpersonationRuleId(String impersonationRuleId) {
        this.impersonationRuleId = impersonationRuleId;
    }

    public String getImpersonationRuleId() {
        return this.impersonationRuleId;
    }

    public ImpersonationRule withImpersonationRuleId(String impersonationRuleId) {
        this.setImpersonationRuleId(impersonationRuleId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ImpersonationRule withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ImpersonationRule withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setEffect(String effect) {
        this.effect = effect;
    }

    public String getEffect() {
        return this.effect;
    }

    public ImpersonationRule withEffect(String effect) {
        this.setEffect(effect);
        return this;
    }

    public ImpersonationRule withEffect(AccessEffect effect) {
        this.effect = effect.toString();
        return this;
    }

    public List<String> getTargetUsers() {
        return this.targetUsers;
    }

    public void setTargetUsers(Collection<String> targetUsers) {
        if (targetUsers == null) {
            this.targetUsers = null;
            return;
        }
        this.targetUsers = new ArrayList<String>(targetUsers);
    }

    public ImpersonationRule withTargetUsers(String ... targetUsers) {
        if (this.targetUsers == null) {
            this.setTargetUsers(new ArrayList<String>(targetUsers.length));
        }
        for (String ele : targetUsers) {
            this.targetUsers.add(ele);
        }
        return this;
    }

    public ImpersonationRule withTargetUsers(Collection<String> targetUsers) {
        this.setTargetUsers(targetUsers);
        return this;
    }

    public List<String> getNotTargetUsers() {
        return this.notTargetUsers;
    }

    public void setNotTargetUsers(Collection<String> notTargetUsers) {
        if (notTargetUsers == null) {
            this.notTargetUsers = null;
            return;
        }
        this.notTargetUsers = new ArrayList<String>(notTargetUsers);
    }

    public ImpersonationRule withNotTargetUsers(String ... notTargetUsers) {
        if (this.notTargetUsers == null) {
            this.setNotTargetUsers(new ArrayList<String>(notTargetUsers.length));
        }
        for (String ele : notTargetUsers) {
            this.notTargetUsers.add(ele);
        }
        return this;
    }

    public ImpersonationRule withNotTargetUsers(Collection<String> notTargetUsers) {
        this.setNotTargetUsers(notTargetUsers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImpersonationRuleId() != null) {
            sb.append("ImpersonationRuleId: ").append(this.getImpersonationRuleId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getEffect() != null) {
            sb.append("Effect: ").append(this.getEffect()).append(",");
        }
        if (this.getTargetUsers() != null) {
            sb.append("TargetUsers: ").append(this.getTargetUsers()).append(",");
        }
        if (this.getNotTargetUsers() != null) {
            sb.append("NotTargetUsers: ").append(this.getNotTargetUsers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImpersonationRule)) {
            return false;
        }
        ImpersonationRule other = (ImpersonationRule)obj;
        if (other.getImpersonationRuleId() == null ^ this.getImpersonationRuleId() == null) {
            return false;
        }
        if (other.getImpersonationRuleId() != null && !other.getImpersonationRuleId().equals(this.getImpersonationRuleId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEffect() == null ^ this.getEffect() == null) {
            return false;
        }
        if (other.getEffect() != null && !other.getEffect().equals(this.getEffect())) {
            return false;
        }
        if (other.getTargetUsers() == null ^ this.getTargetUsers() == null) {
            return false;
        }
        if (other.getTargetUsers() != null && !other.getTargetUsers().equals(this.getTargetUsers())) {
            return false;
        }
        if (other.getNotTargetUsers() == null ^ this.getNotTargetUsers() == null) {
            return false;
        }
        return other.getNotTargetUsers() == null || other.getNotTargetUsers().equals(this.getNotTargetUsers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImpersonationRuleId() == null ? 0 : this.getImpersonationRuleId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEffect() == null ? 0 : this.getEffect().hashCode());
        hashCode = 31 * hashCode + (this.getTargetUsers() == null ? 0 : this.getTargetUsers().hashCode());
        hashCode = 31 * hashCode + (this.getNotTargetUsers() == null ? 0 : this.getNotTargetUsers().hashCode());
        return hashCode;
    }

    public ImpersonationRule clone() {
        try {
            return (ImpersonationRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImpersonationRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

