/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workdocs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.workdocs.model.ResourcePathComponent;
import com.amazonaws.services.workdocs.model.transform.ResourcePathMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResourcePath
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ResourcePathComponent> components;

    public List<ResourcePathComponent> getComponents() {
        return this.components;
    }

    public void setComponents(Collection<ResourcePathComponent> components) {
        if (components == null) {
            this.components = null;
            return;
        }
        this.components = new ArrayList<ResourcePathComponent>(components);
    }

    public ResourcePath withComponents(ResourcePathComponent ... components) {
        if (this.components == null) {
            this.setComponents(new ArrayList<ResourcePathComponent>(components.length));
        }
        for (ResourcePathComponent ele : components) {
            this.components.add(ele);
        }
        return this;
    }

    public ResourcePath withComponents(Collection<ResourcePathComponent> components) {
        this.setComponents(components);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComponents() != null) {
            sb.append("Components: ").append(this.getComponents());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePath)) {
            return false;
        }
        ResourcePath other = (ResourcePath)obj;
        if (other.getComponents() == null ^ this.getComponents() == null) {
            return false;
        }
        return other.getComponents() == null || other.getComponents().equals(this.getComponents());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComponents() == null ? 0 : this.getComponents().hashCode());
        return hashCode;
    }

    public ResourcePath clone() {
        try {
            return (ResourcePath)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourcePathMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

