/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workdocs;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.workdocs.AmazonWorkDocsAsync;
import com.amazonaws.services.workdocs.AmazonWorkDocsAsyncClientBuilder;
import com.amazonaws.services.workdocs.AmazonWorkDocsClient;
import com.amazonaws.services.workdocs.model.AbortDocumentVersionUploadRequest;
import com.amazonaws.services.workdocs.model.AbortDocumentVersionUploadResult;
import com.amazonaws.services.workdocs.model.ActivateUserRequest;
import com.amazonaws.services.workdocs.model.ActivateUserResult;
import com.amazonaws.services.workdocs.model.AddResourcePermissionsRequest;
import com.amazonaws.services.workdocs.model.AddResourcePermissionsResult;
import com.amazonaws.services.workdocs.model.CreateCommentRequest;
import com.amazonaws.services.workdocs.model.CreateCommentResult;
import com.amazonaws.services.workdocs.model.CreateCustomMetadataRequest;
import com.amazonaws.services.workdocs.model.CreateCustomMetadataResult;
import com.amazonaws.services.workdocs.model.CreateFolderRequest;
import com.amazonaws.services.workdocs.model.CreateFolderResult;
import com.amazonaws.services.workdocs.model.CreateLabelsRequest;
import com.amazonaws.services.workdocs.model.CreateLabelsResult;
import com.amazonaws.services.workdocs.model.CreateNotificationSubscriptionRequest;
import com.amazonaws.services.workdocs.model.CreateNotificationSubscriptionResult;
import com.amazonaws.services.workdocs.model.CreateUserRequest;
import com.amazonaws.services.workdocs.model.CreateUserResult;
import com.amazonaws.services.workdocs.model.DeactivateUserRequest;
import com.amazonaws.services.workdocs.model.DeactivateUserResult;
import com.amazonaws.services.workdocs.model.DeleteCommentRequest;
import com.amazonaws.services.workdocs.model.DeleteCommentResult;
import com.amazonaws.services.workdocs.model.DeleteCustomMetadataRequest;
import com.amazonaws.services.workdocs.model.DeleteCustomMetadataResult;
import com.amazonaws.services.workdocs.model.DeleteDocumentRequest;
import com.amazonaws.services.workdocs.model.DeleteDocumentResult;
import com.amazonaws.services.workdocs.model.DeleteFolderContentsRequest;
import com.amazonaws.services.workdocs.model.DeleteFolderContentsResult;
import com.amazonaws.services.workdocs.model.DeleteFolderRequest;
import com.amazonaws.services.workdocs.model.DeleteFolderResult;
import com.amazonaws.services.workdocs.model.DeleteLabelsRequest;
import com.amazonaws.services.workdocs.model.DeleteLabelsResult;
import com.amazonaws.services.workdocs.model.DeleteNotificationSubscriptionRequest;
import com.amazonaws.services.workdocs.model.DeleteNotificationSubscriptionResult;
import com.amazonaws.services.workdocs.model.DeleteUserRequest;
import com.amazonaws.services.workdocs.model.DeleteUserResult;
import com.amazonaws.services.workdocs.model.DescribeActivitiesRequest;
import com.amazonaws.services.workdocs.model.DescribeActivitiesResult;
import com.amazonaws.services.workdocs.model.DescribeCommentsRequest;
import com.amazonaws.services.workdocs.model.DescribeCommentsResult;
import com.amazonaws.services.workdocs.model.DescribeDocumentVersionsRequest;
import com.amazonaws.services.workdocs.model.DescribeDocumentVersionsResult;
import com.amazonaws.services.workdocs.model.DescribeFolderContentsRequest;
import com.amazonaws.services.workdocs.model.DescribeFolderContentsResult;
import com.amazonaws.services.workdocs.model.DescribeGroupsRequest;
import com.amazonaws.services.workdocs.model.DescribeGroupsResult;
import com.amazonaws.services.workdocs.model.DescribeNotificationSubscriptionsRequest;
import com.amazonaws.services.workdocs.model.DescribeNotificationSubscriptionsResult;
import com.amazonaws.services.workdocs.model.DescribeResourcePermissionsRequest;
import com.amazonaws.services.workdocs.model.DescribeResourcePermissionsResult;
import com.amazonaws.services.workdocs.model.DescribeRootFoldersRequest;
import com.amazonaws.services.workdocs.model.DescribeRootFoldersResult;
import com.amazonaws.services.workdocs.model.DescribeUsersRequest;
import com.amazonaws.services.workdocs.model.DescribeUsersResult;
import com.amazonaws.services.workdocs.model.GetCurrentUserRequest;
import com.amazonaws.services.workdocs.model.GetCurrentUserResult;
import com.amazonaws.services.workdocs.model.GetDocumentPathRequest;
import com.amazonaws.services.workdocs.model.GetDocumentPathResult;
import com.amazonaws.services.workdocs.model.GetDocumentRequest;
import com.amazonaws.services.workdocs.model.GetDocumentResult;
import com.amazonaws.services.workdocs.model.GetDocumentVersionRequest;
import com.amazonaws.services.workdocs.model.GetDocumentVersionResult;
import com.amazonaws.services.workdocs.model.GetFolderPathRequest;
import com.amazonaws.services.workdocs.model.GetFolderPathResult;
import com.amazonaws.services.workdocs.model.GetFolderRequest;
import com.amazonaws.services.workdocs.model.GetFolderResult;
import com.amazonaws.services.workdocs.model.GetResourcesRequest;
import com.amazonaws.services.workdocs.model.GetResourcesResult;
import com.amazonaws.services.workdocs.model.InitiateDocumentVersionUploadRequest;
import com.amazonaws.services.workdocs.model.InitiateDocumentVersionUploadResult;
import com.amazonaws.services.workdocs.model.RemoveAllResourcePermissionsRequest;
import com.amazonaws.services.workdocs.model.RemoveAllResourcePermissionsResult;
import com.amazonaws.services.workdocs.model.RemoveResourcePermissionRequest;
import com.amazonaws.services.workdocs.model.RemoveResourcePermissionResult;
import com.amazonaws.services.workdocs.model.UpdateDocumentRequest;
import com.amazonaws.services.workdocs.model.UpdateDocumentResult;
import com.amazonaws.services.workdocs.model.UpdateDocumentVersionRequest;
import com.amazonaws.services.workdocs.model.UpdateDocumentVersionResult;
import com.amazonaws.services.workdocs.model.UpdateFolderRequest;
import com.amazonaws.services.workdocs.model.UpdateFolderResult;
import com.amazonaws.services.workdocs.model.UpdateUserRequest;
import com.amazonaws.services.workdocs.model.UpdateUserResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonWorkDocsAsyncClient
extends AmazonWorkDocsClient
implements AmazonWorkDocsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonWorkDocsAsyncClientBuilder asyncBuilder() {
        return AmazonWorkDocsAsyncClientBuilder.standard();
    }

    AmazonWorkDocsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonWorkDocsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AbortDocumentVersionUploadResult> abortDocumentVersionUploadAsync(AbortDocumentVersionUploadRequest request) {
        return this.abortDocumentVersionUploadAsync(request, null);
    }

    @Override
    public Future<AbortDocumentVersionUploadResult> abortDocumentVersionUploadAsync(AbortDocumentVersionUploadRequest request, final AsyncHandler<AbortDocumentVersionUploadRequest, AbortDocumentVersionUploadResult> asyncHandler) {
        final AbortDocumentVersionUploadRequest finalRequest = (AbortDocumentVersionUploadRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AbortDocumentVersionUploadResult>(){

            @Override
            public AbortDocumentVersionUploadResult call() throws Exception {
                AbortDocumentVersionUploadResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeAbortDocumentVersionUpload(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ActivateUserResult> activateUserAsync(ActivateUserRequest request) {
        return this.activateUserAsync(request, null);
    }

    @Override
    public Future<ActivateUserResult> activateUserAsync(ActivateUserRequest request, final AsyncHandler<ActivateUserRequest, ActivateUserResult> asyncHandler) {
        final ActivateUserRequest finalRequest = (ActivateUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ActivateUserResult>(){

            @Override
            public ActivateUserResult call() throws Exception {
                ActivateUserResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeActivateUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddResourcePermissionsResult> addResourcePermissionsAsync(AddResourcePermissionsRequest request) {
        return this.addResourcePermissionsAsync(request, null);
    }

    @Override
    public Future<AddResourcePermissionsResult> addResourcePermissionsAsync(AddResourcePermissionsRequest request, final AsyncHandler<AddResourcePermissionsRequest, AddResourcePermissionsResult> asyncHandler) {
        final AddResourcePermissionsRequest finalRequest = (AddResourcePermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddResourcePermissionsResult>(){

            @Override
            public AddResourcePermissionsResult call() throws Exception {
                AddResourcePermissionsResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeAddResourcePermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCommentResult> createCommentAsync(CreateCommentRequest request) {
        return this.createCommentAsync(request, null);
    }

    @Override
    public Future<CreateCommentResult> createCommentAsync(CreateCommentRequest request, final AsyncHandler<CreateCommentRequest, CreateCommentResult> asyncHandler) {
        final CreateCommentRequest finalRequest = (CreateCommentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCommentResult>(){

            @Override
            public CreateCommentResult call() throws Exception {
                CreateCommentResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeCreateComment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCustomMetadataResult> createCustomMetadataAsync(CreateCustomMetadataRequest request) {
        return this.createCustomMetadataAsync(request, null);
    }

    @Override
    public Future<CreateCustomMetadataResult> createCustomMetadataAsync(CreateCustomMetadataRequest request, final AsyncHandler<CreateCustomMetadataRequest, CreateCustomMetadataResult> asyncHandler) {
        final CreateCustomMetadataRequest finalRequest = (CreateCustomMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCustomMetadataResult>(){

            @Override
            public CreateCustomMetadataResult call() throws Exception {
                CreateCustomMetadataResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeCreateCustomMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFolderResult> createFolderAsync(CreateFolderRequest request) {
        return this.createFolderAsync(request, null);
    }

    @Override
    public Future<CreateFolderResult> createFolderAsync(CreateFolderRequest request, final AsyncHandler<CreateFolderRequest, CreateFolderResult> asyncHandler) {
        final CreateFolderRequest finalRequest = (CreateFolderRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFolderResult>(){

            @Override
            public CreateFolderResult call() throws Exception {
                CreateFolderResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeCreateFolder(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLabelsResult> createLabelsAsync(CreateLabelsRequest request) {
        return this.createLabelsAsync(request, null);
    }

    @Override
    public Future<CreateLabelsResult> createLabelsAsync(CreateLabelsRequest request, final AsyncHandler<CreateLabelsRequest, CreateLabelsResult> asyncHandler) {
        final CreateLabelsRequest finalRequest = (CreateLabelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLabelsResult>(){

            @Override
            public CreateLabelsResult call() throws Exception {
                CreateLabelsResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeCreateLabels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateNotificationSubscriptionResult> createNotificationSubscriptionAsync(CreateNotificationSubscriptionRequest request) {
        return this.createNotificationSubscriptionAsync(request, null);
    }

    @Override
    public Future<CreateNotificationSubscriptionResult> createNotificationSubscriptionAsync(CreateNotificationSubscriptionRequest request, final AsyncHandler<CreateNotificationSubscriptionRequest, CreateNotificationSubscriptionResult> asyncHandler) {
        final CreateNotificationSubscriptionRequest finalRequest = (CreateNotificationSubscriptionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateNotificationSubscriptionResult>(){

            @Override
            public CreateNotificationSubscriptionResult call() throws Exception {
                CreateNotificationSubscriptionResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeCreateNotificationSubscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateUserResult> createUserAsync(CreateUserRequest request) {
        return this.createUserAsync(request, null);
    }

    @Override
    public Future<CreateUserResult> createUserAsync(CreateUserRequest request, final AsyncHandler<CreateUserRequest, CreateUserResult> asyncHandler) {
        final CreateUserRequest finalRequest = (CreateUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateUserResult>(){

            @Override
            public CreateUserResult call() throws Exception {
                CreateUserResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeCreateUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeactivateUserResult> deactivateUserAsync(DeactivateUserRequest request) {
        return this.deactivateUserAsync(request, null);
    }

    @Override
    public Future<DeactivateUserResult> deactivateUserAsync(DeactivateUserRequest request, final AsyncHandler<DeactivateUserRequest, DeactivateUserResult> asyncHandler) {
        final DeactivateUserRequest finalRequest = (DeactivateUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeactivateUserResult>(){

            @Override
            public DeactivateUserResult call() throws Exception {
                DeactivateUserResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeDeactivateUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCommentResult> deleteCommentAsync(DeleteCommentRequest request) {
        return this.deleteCommentAsync(request, null);
    }

    @Override
    public Future<DeleteCommentResult> deleteCommentAsync(DeleteCommentRequest request, final AsyncHandler<DeleteCommentRequest, DeleteCommentResult> asyncHandler) {
        final DeleteCommentRequest finalRequest = (DeleteCommentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCommentResult>(){

            @Override
            public DeleteCommentResult call() throws Exception {
                DeleteCommentResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeDeleteComment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCustomMetadataResult> deleteCustomMetadataAsync(DeleteCustomMetadataRequest request) {
        return this.deleteCustomMetadataAsync(request, null);
    }

    @Override
    public Future<DeleteCustomMetadataResult> deleteCustomMetadataAsync(DeleteCustomMetadataRequest request, final AsyncHandler<DeleteCustomMetadataRequest, DeleteCustomMetadataResult> asyncHandler) {
        final DeleteCustomMetadataRequest finalRequest = (DeleteCustomMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCustomMetadataResult>(){

            @Override
            public DeleteCustomMetadataResult call() throws Exception {
                DeleteCustomMetadataResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeDeleteCustomMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDocumentResult> deleteDocumentAsync(DeleteDocumentRequest request) {
        return this.deleteDocumentAsync(request, null);
    }

    @Override
    public Future<DeleteDocumentResult> deleteDocumentAsync(DeleteDocumentRequest request, final AsyncHandler<DeleteDocumentRequest, DeleteDocumentResult> asyncHandler) {
        final DeleteDocumentRequest finalRequest = (DeleteDocumentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDocumentResult>(){

            @Override
            public DeleteDocumentResult call() throws Exception {
                DeleteDocumentResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeDeleteDocument(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFolderResult> deleteFolderAsync(DeleteFolderRequest request) {
        return this.deleteFolderAsync(request, null);
    }

    @Override
    public Future<DeleteFolderResult> deleteFolderAsync(DeleteFolderRequest request, final AsyncHandler<DeleteFolderRequest, DeleteFolderResult> asyncHandler) {
        final DeleteFolderRequest finalRequest = (DeleteFolderRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFolderResult>(){

            @Override
            public DeleteFolderResult call() throws Exception {
                DeleteFolderResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeDeleteFolder(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFolderContentsResult> deleteFolderContentsAsync(DeleteFolderContentsRequest request) {
        return this.deleteFolderContentsAsync(request, null);
    }

    @Override
    public Future<DeleteFolderContentsResult> deleteFolderContentsAsync(DeleteFolderContentsRequest request, final AsyncHandler<DeleteFolderContentsRequest, DeleteFolderContentsResult> asyncHandler) {
        final DeleteFolderContentsRequest finalRequest = (DeleteFolderContentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFolderContentsResult>(){

            @Override
            public DeleteFolderContentsResult call() throws Exception {
                DeleteFolderContentsResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeDeleteFolderContents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLabelsResult> deleteLabelsAsync(DeleteLabelsRequest request) {
        return this.deleteLabelsAsync(request, null);
    }

    @Override
    public Future<DeleteLabelsResult> deleteLabelsAsync(DeleteLabelsRequest request, final AsyncHandler<DeleteLabelsRequest, DeleteLabelsResult> asyncHandler) {
        final DeleteLabelsRequest finalRequest = (DeleteLabelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteLabelsResult>(){

            @Override
            public DeleteLabelsResult call() throws Exception {
                DeleteLabelsResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeDeleteLabels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteNotificationSubscriptionResult> deleteNotificationSubscriptionAsync(DeleteNotificationSubscriptionRequest request) {
        return this.deleteNotificationSubscriptionAsync(request, null);
    }

    @Override
    public Future<DeleteNotificationSubscriptionResult> deleteNotificationSubscriptionAsync(DeleteNotificationSubscriptionRequest request, final AsyncHandler<DeleteNotificationSubscriptionRequest, DeleteNotificationSubscriptionResult> asyncHandler) {
        final DeleteNotificationSubscriptionRequest finalRequest = (DeleteNotificationSubscriptionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteNotificationSubscriptionResult>(){

            @Override
            public DeleteNotificationSubscriptionResult call() throws Exception {
                DeleteNotificationSubscriptionResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeDeleteNotificationSubscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request) {
        return this.deleteUserAsync(request, null);
    }

    @Override
    public Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request, final AsyncHandler<DeleteUserRequest, DeleteUserResult> asyncHandler) {
        final DeleteUserRequest finalRequest = (DeleteUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteUserResult>(){

            @Override
            public DeleteUserResult call() throws Exception {
                DeleteUserResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeDeleteUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeActivitiesResult> describeActivitiesAsync(DescribeActivitiesRequest request) {
        return this.describeActivitiesAsync(request, null);
    }

    @Override
    public Future<DescribeActivitiesResult> describeActivitiesAsync(DescribeActivitiesRequest request, final AsyncHandler<DescribeActivitiesRequest, DescribeActivitiesResult> asyncHandler) {
        final DescribeActivitiesRequest finalRequest = (DescribeActivitiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeActivitiesResult>(){

            @Override
            public DescribeActivitiesResult call() throws Exception {
                DescribeActivitiesResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeDescribeActivities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCommentsResult> describeCommentsAsync(DescribeCommentsRequest request) {
        return this.describeCommentsAsync(request, null);
    }

    @Override
    public Future<DescribeCommentsResult> describeCommentsAsync(DescribeCommentsRequest request, final AsyncHandler<DescribeCommentsRequest, DescribeCommentsResult> asyncHandler) {
        final DescribeCommentsRequest finalRequest = (DescribeCommentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCommentsResult>(){

            @Override
            public DescribeCommentsResult call() throws Exception {
                DescribeCommentsResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeDescribeComments(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDocumentVersionsResult> describeDocumentVersionsAsync(DescribeDocumentVersionsRequest request) {
        return this.describeDocumentVersionsAsync(request, null);
    }

    @Override
    public Future<DescribeDocumentVersionsResult> describeDocumentVersionsAsync(DescribeDocumentVersionsRequest request, final AsyncHandler<DescribeDocumentVersionsRequest, DescribeDocumentVersionsResult> asyncHandler) {
        final DescribeDocumentVersionsRequest finalRequest = (DescribeDocumentVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDocumentVersionsResult>(){

            @Override
            public DescribeDocumentVersionsResult call() throws Exception {
                DescribeDocumentVersionsResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeDescribeDocumentVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFolderContentsResult> describeFolderContentsAsync(DescribeFolderContentsRequest request) {
        return this.describeFolderContentsAsync(request, null);
    }

    @Override
    public Future<DescribeFolderContentsResult> describeFolderContentsAsync(DescribeFolderContentsRequest request, final AsyncHandler<DescribeFolderContentsRequest, DescribeFolderContentsResult> asyncHandler) {
        final DescribeFolderContentsRequest finalRequest = (DescribeFolderContentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFolderContentsResult>(){

            @Override
            public DescribeFolderContentsResult call() throws Exception {
                DescribeFolderContentsResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeDescribeFolderContents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeGroupsResult> describeGroupsAsync(DescribeGroupsRequest request) {
        return this.describeGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeGroupsResult> describeGroupsAsync(DescribeGroupsRequest request, final AsyncHandler<DescribeGroupsRequest, DescribeGroupsResult> asyncHandler) {
        final DescribeGroupsRequest finalRequest = (DescribeGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeGroupsResult>(){

            @Override
            public DescribeGroupsResult call() throws Exception {
                DescribeGroupsResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeDescribeGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeNotificationSubscriptionsResult> describeNotificationSubscriptionsAsync(DescribeNotificationSubscriptionsRequest request) {
        return this.describeNotificationSubscriptionsAsync(request, null);
    }

    @Override
    public Future<DescribeNotificationSubscriptionsResult> describeNotificationSubscriptionsAsync(DescribeNotificationSubscriptionsRequest request, final AsyncHandler<DescribeNotificationSubscriptionsRequest, DescribeNotificationSubscriptionsResult> asyncHandler) {
        final DescribeNotificationSubscriptionsRequest finalRequest = (DescribeNotificationSubscriptionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeNotificationSubscriptionsResult>(){

            @Override
            public DescribeNotificationSubscriptionsResult call() throws Exception {
                DescribeNotificationSubscriptionsResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeDescribeNotificationSubscriptions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeResourcePermissionsResult> describeResourcePermissionsAsync(DescribeResourcePermissionsRequest request) {
        return this.describeResourcePermissionsAsync(request, null);
    }

    @Override
    public Future<DescribeResourcePermissionsResult> describeResourcePermissionsAsync(DescribeResourcePermissionsRequest request, final AsyncHandler<DescribeResourcePermissionsRequest, DescribeResourcePermissionsResult> asyncHandler) {
        final DescribeResourcePermissionsRequest finalRequest = (DescribeResourcePermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeResourcePermissionsResult>(){

            @Override
            public DescribeResourcePermissionsResult call() throws Exception {
                DescribeResourcePermissionsResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeDescribeResourcePermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRootFoldersResult> describeRootFoldersAsync(DescribeRootFoldersRequest request) {
        return this.describeRootFoldersAsync(request, null);
    }

    @Override
    public Future<DescribeRootFoldersResult> describeRootFoldersAsync(DescribeRootFoldersRequest request, final AsyncHandler<DescribeRootFoldersRequest, DescribeRootFoldersResult> asyncHandler) {
        final DescribeRootFoldersRequest finalRequest = (DescribeRootFoldersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRootFoldersResult>(){

            @Override
            public DescribeRootFoldersResult call() throws Exception {
                DescribeRootFoldersResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeDescribeRootFolders(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeUsersResult> describeUsersAsync(DescribeUsersRequest request) {
        return this.describeUsersAsync(request, null);
    }

    @Override
    public Future<DescribeUsersResult> describeUsersAsync(DescribeUsersRequest request, final AsyncHandler<DescribeUsersRequest, DescribeUsersResult> asyncHandler) {
        final DescribeUsersRequest finalRequest = (DescribeUsersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeUsersResult>(){

            @Override
            public DescribeUsersResult call() throws Exception {
                DescribeUsersResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeDescribeUsers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCurrentUserResult> getCurrentUserAsync(GetCurrentUserRequest request) {
        return this.getCurrentUserAsync(request, null);
    }

    @Override
    public Future<GetCurrentUserResult> getCurrentUserAsync(GetCurrentUserRequest request, final AsyncHandler<GetCurrentUserRequest, GetCurrentUserResult> asyncHandler) {
        final GetCurrentUserRequest finalRequest = (GetCurrentUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCurrentUserResult>(){

            @Override
            public GetCurrentUserResult call() throws Exception {
                GetCurrentUserResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeGetCurrentUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDocumentResult> getDocumentAsync(GetDocumentRequest request) {
        return this.getDocumentAsync(request, null);
    }

    @Override
    public Future<GetDocumentResult> getDocumentAsync(GetDocumentRequest request, final AsyncHandler<GetDocumentRequest, GetDocumentResult> asyncHandler) {
        final GetDocumentRequest finalRequest = (GetDocumentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDocumentResult>(){

            @Override
            public GetDocumentResult call() throws Exception {
                GetDocumentResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeGetDocument(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDocumentPathResult> getDocumentPathAsync(GetDocumentPathRequest request) {
        return this.getDocumentPathAsync(request, null);
    }

    @Override
    public Future<GetDocumentPathResult> getDocumentPathAsync(GetDocumentPathRequest request, final AsyncHandler<GetDocumentPathRequest, GetDocumentPathResult> asyncHandler) {
        final GetDocumentPathRequest finalRequest = (GetDocumentPathRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDocumentPathResult>(){

            @Override
            public GetDocumentPathResult call() throws Exception {
                GetDocumentPathResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeGetDocumentPath(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDocumentVersionResult> getDocumentVersionAsync(GetDocumentVersionRequest request) {
        return this.getDocumentVersionAsync(request, null);
    }

    @Override
    public Future<GetDocumentVersionResult> getDocumentVersionAsync(GetDocumentVersionRequest request, final AsyncHandler<GetDocumentVersionRequest, GetDocumentVersionResult> asyncHandler) {
        final GetDocumentVersionRequest finalRequest = (GetDocumentVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDocumentVersionResult>(){

            @Override
            public GetDocumentVersionResult call() throws Exception {
                GetDocumentVersionResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeGetDocumentVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFolderResult> getFolderAsync(GetFolderRequest request) {
        return this.getFolderAsync(request, null);
    }

    @Override
    public Future<GetFolderResult> getFolderAsync(GetFolderRequest request, final AsyncHandler<GetFolderRequest, GetFolderResult> asyncHandler) {
        final GetFolderRequest finalRequest = (GetFolderRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFolderResult>(){

            @Override
            public GetFolderResult call() throws Exception {
                GetFolderResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeGetFolder(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFolderPathResult> getFolderPathAsync(GetFolderPathRequest request) {
        return this.getFolderPathAsync(request, null);
    }

    @Override
    public Future<GetFolderPathResult> getFolderPathAsync(GetFolderPathRequest request, final AsyncHandler<GetFolderPathRequest, GetFolderPathResult> asyncHandler) {
        final GetFolderPathRequest finalRequest = (GetFolderPathRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFolderPathResult>(){

            @Override
            public GetFolderPathResult call() throws Exception {
                GetFolderPathResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeGetFolderPath(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResourcesResult> getResourcesAsync(GetResourcesRequest request) {
        return this.getResourcesAsync(request, null);
    }

    @Override
    public Future<GetResourcesResult> getResourcesAsync(GetResourcesRequest request, final AsyncHandler<GetResourcesRequest, GetResourcesResult> asyncHandler) {
        final GetResourcesRequest finalRequest = (GetResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourcesResult>(){

            @Override
            public GetResourcesResult call() throws Exception {
                GetResourcesResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeGetResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InitiateDocumentVersionUploadResult> initiateDocumentVersionUploadAsync(InitiateDocumentVersionUploadRequest request) {
        return this.initiateDocumentVersionUploadAsync(request, null);
    }

    @Override
    public Future<InitiateDocumentVersionUploadResult> initiateDocumentVersionUploadAsync(InitiateDocumentVersionUploadRequest request, final AsyncHandler<InitiateDocumentVersionUploadRequest, InitiateDocumentVersionUploadResult> asyncHandler) {
        final InitiateDocumentVersionUploadRequest finalRequest = (InitiateDocumentVersionUploadRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<InitiateDocumentVersionUploadResult>(){

            @Override
            public InitiateDocumentVersionUploadResult call() throws Exception {
                InitiateDocumentVersionUploadResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeInitiateDocumentVersionUpload(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveAllResourcePermissionsResult> removeAllResourcePermissionsAsync(RemoveAllResourcePermissionsRequest request) {
        return this.removeAllResourcePermissionsAsync(request, null);
    }

    @Override
    public Future<RemoveAllResourcePermissionsResult> removeAllResourcePermissionsAsync(RemoveAllResourcePermissionsRequest request, final AsyncHandler<RemoveAllResourcePermissionsRequest, RemoveAllResourcePermissionsResult> asyncHandler) {
        final RemoveAllResourcePermissionsRequest finalRequest = (RemoveAllResourcePermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveAllResourcePermissionsResult>(){

            @Override
            public RemoveAllResourcePermissionsResult call() throws Exception {
                RemoveAllResourcePermissionsResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeRemoveAllResourcePermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveResourcePermissionResult> removeResourcePermissionAsync(RemoveResourcePermissionRequest request) {
        return this.removeResourcePermissionAsync(request, null);
    }

    @Override
    public Future<RemoveResourcePermissionResult> removeResourcePermissionAsync(RemoveResourcePermissionRequest request, final AsyncHandler<RemoveResourcePermissionRequest, RemoveResourcePermissionResult> asyncHandler) {
        final RemoveResourcePermissionRequest finalRequest = (RemoveResourcePermissionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveResourcePermissionResult>(){

            @Override
            public RemoveResourcePermissionResult call() throws Exception {
                RemoveResourcePermissionResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeRemoveResourcePermission(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDocumentResult> updateDocumentAsync(UpdateDocumentRequest request) {
        return this.updateDocumentAsync(request, null);
    }

    @Override
    public Future<UpdateDocumentResult> updateDocumentAsync(UpdateDocumentRequest request, final AsyncHandler<UpdateDocumentRequest, UpdateDocumentResult> asyncHandler) {
        final UpdateDocumentRequest finalRequest = (UpdateDocumentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDocumentResult>(){

            @Override
            public UpdateDocumentResult call() throws Exception {
                UpdateDocumentResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeUpdateDocument(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDocumentVersionResult> updateDocumentVersionAsync(UpdateDocumentVersionRequest request) {
        return this.updateDocumentVersionAsync(request, null);
    }

    @Override
    public Future<UpdateDocumentVersionResult> updateDocumentVersionAsync(UpdateDocumentVersionRequest request, final AsyncHandler<UpdateDocumentVersionRequest, UpdateDocumentVersionResult> asyncHandler) {
        final UpdateDocumentVersionRequest finalRequest = (UpdateDocumentVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDocumentVersionResult>(){

            @Override
            public UpdateDocumentVersionResult call() throws Exception {
                UpdateDocumentVersionResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeUpdateDocumentVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFolderResult> updateFolderAsync(UpdateFolderRequest request) {
        return this.updateFolderAsync(request, null);
    }

    @Override
    public Future<UpdateFolderResult> updateFolderAsync(UpdateFolderRequest request, final AsyncHandler<UpdateFolderRequest, UpdateFolderResult> asyncHandler) {
        final UpdateFolderRequest finalRequest = (UpdateFolderRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFolderResult>(){

            @Override
            public UpdateFolderResult call() throws Exception {
                UpdateFolderResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeUpdateFolder(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request) {
        return this.updateUserAsync(request, null);
    }

    @Override
    public Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request, final AsyncHandler<UpdateUserRequest, UpdateUserResult> asyncHandler) {
        final UpdateUserRequest finalRequest = (UpdateUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateUserResult>(){

            @Override
            public UpdateUserResult call() throws Exception {
                UpdateUserResult result = null;
                try {
                    result = AmazonWorkDocsAsyncClient.this.executeUpdateUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

