/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wellarchitected.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wellarchitected.model.ProfileChoice;
import com.amazonaws.services.wellarchitected.model.transform.ProfileQuestionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ProfileQuestion
implements Serializable,
Cloneable,
StructuredPojo {
    private String questionId;
    private String questionTitle;
    private String questionDescription;
    private List<ProfileChoice> questionChoices;
    private List<String> selectedChoiceIds;
    private Integer minSelectedChoices;
    private Integer maxSelectedChoices;

    public void setQuestionId(String questionId) {
        this.questionId = questionId;
    }

    public String getQuestionId() {
        return this.questionId;
    }

    public ProfileQuestion withQuestionId(String questionId) {
        this.setQuestionId(questionId);
        return this;
    }

    public void setQuestionTitle(String questionTitle) {
        this.questionTitle = questionTitle;
    }

    public String getQuestionTitle() {
        return this.questionTitle;
    }

    public ProfileQuestion withQuestionTitle(String questionTitle) {
        this.setQuestionTitle(questionTitle);
        return this;
    }

    public void setQuestionDescription(String questionDescription) {
        this.questionDescription = questionDescription;
    }

    public String getQuestionDescription() {
        return this.questionDescription;
    }

    public ProfileQuestion withQuestionDescription(String questionDescription) {
        this.setQuestionDescription(questionDescription);
        return this;
    }

    public List<ProfileChoice> getQuestionChoices() {
        return this.questionChoices;
    }

    public void setQuestionChoices(Collection<ProfileChoice> questionChoices) {
        if (questionChoices == null) {
            this.questionChoices = null;
            return;
        }
        this.questionChoices = new ArrayList<ProfileChoice>(questionChoices);
    }

    public ProfileQuestion withQuestionChoices(ProfileChoice ... questionChoices) {
        if (this.questionChoices == null) {
            this.setQuestionChoices(new ArrayList<ProfileChoice>(questionChoices.length));
        }
        for (ProfileChoice ele : questionChoices) {
            this.questionChoices.add(ele);
        }
        return this;
    }

    public ProfileQuestion withQuestionChoices(Collection<ProfileChoice> questionChoices) {
        this.setQuestionChoices(questionChoices);
        return this;
    }

    public List<String> getSelectedChoiceIds() {
        return this.selectedChoiceIds;
    }

    public void setSelectedChoiceIds(Collection<String> selectedChoiceIds) {
        if (selectedChoiceIds == null) {
            this.selectedChoiceIds = null;
            return;
        }
        this.selectedChoiceIds = new ArrayList<String>(selectedChoiceIds);
    }

    public ProfileQuestion withSelectedChoiceIds(String ... selectedChoiceIds) {
        if (this.selectedChoiceIds == null) {
            this.setSelectedChoiceIds(new ArrayList<String>(selectedChoiceIds.length));
        }
        for (String ele : selectedChoiceIds) {
            this.selectedChoiceIds.add(ele);
        }
        return this;
    }

    public ProfileQuestion withSelectedChoiceIds(Collection<String> selectedChoiceIds) {
        this.setSelectedChoiceIds(selectedChoiceIds);
        return this;
    }

    public void setMinSelectedChoices(Integer minSelectedChoices) {
        this.minSelectedChoices = minSelectedChoices;
    }

    public Integer getMinSelectedChoices() {
        return this.minSelectedChoices;
    }

    public ProfileQuestion withMinSelectedChoices(Integer minSelectedChoices) {
        this.setMinSelectedChoices(minSelectedChoices);
        return this;
    }

    public void setMaxSelectedChoices(Integer maxSelectedChoices) {
        this.maxSelectedChoices = maxSelectedChoices;
    }

    public Integer getMaxSelectedChoices() {
        return this.maxSelectedChoices;
    }

    public ProfileQuestion withMaxSelectedChoices(Integer maxSelectedChoices) {
        this.setMaxSelectedChoices(maxSelectedChoices);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQuestionId() != null) {
            sb.append("QuestionId: ").append(this.getQuestionId()).append(",");
        }
        if (this.getQuestionTitle() != null) {
            sb.append("QuestionTitle: ").append(this.getQuestionTitle()).append(",");
        }
        if (this.getQuestionDescription() != null) {
            sb.append("QuestionDescription: ").append(this.getQuestionDescription()).append(",");
        }
        if (this.getQuestionChoices() != null) {
            sb.append("QuestionChoices: ").append(this.getQuestionChoices()).append(",");
        }
        if (this.getSelectedChoiceIds() != null) {
            sb.append("SelectedChoiceIds: ").append(this.getSelectedChoiceIds()).append(",");
        }
        if (this.getMinSelectedChoices() != null) {
            sb.append("MinSelectedChoices: ").append(this.getMinSelectedChoices()).append(",");
        }
        if (this.getMaxSelectedChoices() != null) {
            sb.append("MaxSelectedChoices: ").append(this.getMaxSelectedChoices());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileQuestion)) {
            return false;
        }
        ProfileQuestion other = (ProfileQuestion)obj;
        if (other.getQuestionId() == null ^ this.getQuestionId() == null) {
            return false;
        }
        if (other.getQuestionId() != null && !other.getQuestionId().equals(this.getQuestionId())) {
            return false;
        }
        if (other.getQuestionTitle() == null ^ this.getQuestionTitle() == null) {
            return false;
        }
        if (other.getQuestionTitle() != null && !other.getQuestionTitle().equals(this.getQuestionTitle())) {
            return false;
        }
        if (other.getQuestionDescription() == null ^ this.getQuestionDescription() == null) {
            return false;
        }
        if (other.getQuestionDescription() != null && !other.getQuestionDescription().equals(this.getQuestionDescription())) {
            return false;
        }
        if (other.getQuestionChoices() == null ^ this.getQuestionChoices() == null) {
            return false;
        }
        if (other.getQuestionChoices() != null && !other.getQuestionChoices().equals(this.getQuestionChoices())) {
            return false;
        }
        if (other.getSelectedChoiceIds() == null ^ this.getSelectedChoiceIds() == null) {
            return false;
        }
        if (other.getSelectedChoiceIds() != null && !other.getSelectedChoiceIds().equals(this.getSelectedChoiceIds())) {
            return false;
        }
        if (other.getMinSelectedChoices() == null ^ this.getMinSelectedChoices() == null) {
            return false;
        }
        if (other.getMinSelectedChoices() != null && !other.getMinSelectedChoices().equals(this.getMinSelectedChoices())) {
            return false;
        }
        if (other.getMaxSelectedChoices() == null ^ this.getMaxSelectedChoices() == null) {
            return false;
        }
        return other.getMaxSelectedChoices() == null || other.getMaxSelectedChoices().equals(this.getMaxSelectedChoices());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQuestionId() == null ? 0 : this.getQuestionId().hashCode());
        hashCode = 31 * hashCode + (this.getQuestionTitle() == null ? 0 : this.getQuestionTitle().hashCode());
        hashCode = 31 * hashCode + (this.getQuestionDescription() == null ? 0 : this.getQuestionDescription().hashCode());
        hashCode = 31 * hashCode + (this.getQuestionChoices() == null ? 0 : this.getQuestionChoices().hashCode());
        hashCode = 31 * hashCode + (this.getSelectedChoiceIds() == null ? 0 : this.getSelectedChoiceIds().hashCode());
        hashCode = 31 * hashCode + (this.getMinSelectedChoices() == null ? 0 : this.getMinSelectedChoices().hashCode());
        hashCode = 31 * hashCode + (this.getMaxSelectedChoices() == null ? 0 : this.getMaxSelectedChoices().hashCode());
        return hashCode;
    }

    public ProfileQuestion clone() {
        try {
            return (ProfileQuestion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProfileQuestionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

