/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wellarchitected.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wellarchitected.model.PillarMetric;
import com.amazonaws.services.wellarchitected.model.transform.LensMetricMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LensMetric
implements Serializable,
Cloneable,
StructuredPojo {
    private String lensArn;
    private List<PillarMetric> pillars;
    private Map<String, Integer> riskCounts;

    public void setLensArn(String lensArn) {
        this.lensArn = lensArn;
    }

    public String getLensArn() {
        return this.lensArn;
    }

    public LensMetric withLensArn(String lensArn) {
        this.setLensArn(lensArn);
        return this;
    }

    public List<PillarMetric> getPillars() {
        return this.pillars;
    }

    public void setPillars(Collection<PillarMetric> pillars) {
        if (pillars == null) {
            this.pillars = null;
            return;
        }
        this.pillars = new ArrayList<PillarMetric>(pillars);
    }

    public LensMetric withPillars(PillarMetric ... pillars) {
        if (this.pillars == null) {
            this.setPillars(new ArrayList<PillarMetric>(pillars.length));
        }
        for (PillarMetric ele : pillars) {
            this.pillars.add(ele);
        }
        return this;
    }

    public LensMetric withPillars(Collection<PillarMetric> pillars) {
        this.setPillars(pillars);
        return this;
    }

    public Map<String, Integer> getRiskCounts() {
        return this.riskCounts;
    }

    public void setRiskCounts(Map<String, Integer> riskCounts) {
        this.riskCounts = riskCounts;
    }

    public LensMetric withRiskCounts(Map<String, Integer> riskCounts) {
        this.setRiskCounts(riskCounts);
        return this;
    }

    public LensMetric addRiskCountsEntry(String key, Integer value) {
        if (null == this.riskCounts) {
            this.riskCounts = new HashMap<String, Integer>();
        }
        if (this.riskCounts.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.riskCounts.put(key, value);
        return this;
    }

    public LensMetric clearRiskCountsEntries() {
        this.riskCounts = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLensArn() != null) {
            sb.append("LensArn: ").append(this.getLensArn()).append(",");
        }
        if (this.getPillars() != null) {
            sb.append("Pillars: ").append(this.getPillars()).append(",");
        }
        if (this.getRiskCounts() != null) {
            sb.append("RiskCounts: ").append(this.getRiskCounts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LensMetric)) {
            return false;
        }
        LensMetric other = (LensMetric)obj;
        if (other.getLensArn() == null ^ this.getLensArn() == null) {
            return false;
        }
        if (other.getLensArn() != null && !other.getLensArn().equals(this.getLensArn())) {
            return false;
        }
        if (other.getPillars() == null ^ this.getPillars() == null) {
            return false;
        }
        if (other.getPillars() != null && !other.getPillars().equals(this.getPillars())) {
            return false;
        }
        if (other.getRiskCounts() == null ^ this.getRiskCounts() == null) {
            return false;
        }
        return other.getRiskCounts() == null || other.getRiskCounts().equals(this.getRiskCounts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLensArn() == null ? 0 : this.getLensArn().hashCode());
        hashCode = 31 * hashCode + (this.getPillars() == null ? 0 : this.getPillars().hashCode());
        hashCode = 31 * hashCode + (this.getRiskCounts() == null ? 0 : this.getRiskCounts().hashCode());
        return hashCode;
    }

    public LensMetric clone() {
        try {
            return (LensMetric)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LensMetricMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

