/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wellarchitected.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wellarchitected.model.ProfileQuestion;
import com.amazonaws.services.wellarchitected.model.transform.ProfileMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Profile
implements Serializable,
Cloneable,
StructuredPojo {
    private String profileArn;
    private String profileVersion;
    private String profileName;
    private String profileDescription;
    private List<ProfileQuestion> profileQuestions;
    private String owner;
    private Date createdAt;
    private Date updatedAt;
    private String shareInvitationId;
    private Map<String, String> tags;

    public void setProfileArn(String profileArn) {
        this.profileArn = profileArn;
    }

    public String getProfileArn() {
        return this.profileArn;
    }

    public Profile withProfileArn(String profileArn) {
        this.setProfileArn(profileArn);
        return this;
    }

    public void setProfileVersion(String profileVersion) {
        this.profileVersion = profileVersion;
    }

    public String getProfileVersion() {
        return this.profileVersion;
    }

    public Profile withProfileVersion(String profileVersion) {
        this.setProfileVersion(profileVersion);
        return this;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public Profile withProfileName(String profileName) {
        this.setProfileName(profileName);
        return this;
    }

    public void setProfileDescription(String profileDescription) {
        this.profileDescription = profileDescription;
    }

    public String getProfileDescription() {
        return this.profileDescription;
    }

    public Profile withProfileDescription(String profileDescription) {
        this.setProfileDescription(profileDescription);
        return this;
    }

    public List<ProfileQuestion> getProfileQuestions() {
        return this.profileQuestions;
    }

    public void setProfileQuestions(Collection<ProfileQuestion> profileQuestions) {
        if (profileQuestions == null) {
            this.profileQuestions = null;
            return;
        }
        this.profileQuestions = new ArrayList<ProfileQuestion>(profileQuestions);
    }

    public Profile withProfileQuestions(ProfileQuestion ... profileQuestions) {
        if (this.profileQuestions == null) {
            this.setProfileQuestions(new ArrayList<ProfileQuestion>(profileQuestions.length));
        }
        for (ProfileQuestion ele : profileQuestions) {
            this.profileQuestions.add(ele);
        }
        return this;
    }

    public Profile withProfileQuestions(Collection<ProfileQuestion> profileQuestions) {
        this.setProfileQuestions(profileQuestions);
        return this;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public Profile withOwner(String owner) {
        this.setOwner(owner);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Profile withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public Profile withUpdatedAt(Date updatedAt) {
        this.setUpdatedAt(updatedAt);
        return this;
    }

    public void setShareInvitationId(String shareInvitationId) {
        this.shareInvitationId = shareInvitationId;
    }

    public String getShareInvitationId() {
        return this.shareInvitationId;
    }

    public Profile withShareInvitationId(String shareInvitationId) {
        this.setShareInvitationId(shareInvitationId);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Profile withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Profile addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Profile clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProfileArn() != null) {
            sb.append("ProfileArn: ").append(this.getProfileArn()).append(",");
        }
        if (this.getProfileVersion() != null) {
            sb.append("ProfileVersion: ").append(this.getProfileVersion()).append(",");
        }
        if (this.getProfileName() != null) {
            sb.append("ProfileName: ").append(this.getProfileName()).append(",");
        }
        if (this.getProfileDescription() != null) {
            sb.append("ProfileDescription: ").append(this.getProfileDescription()).append(",");
        }
        if (this.getProfileQuestions() != null) {
            sb.append("ProfileQuestions: ").append(this.getProfileQuestions()).append(",");
        }
        if (this.getOwner() != null) {
            sb.append("Owner: ").append(this.getOwner()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getUpdatedAt() != null) {
            sb.append("UpdatedAt: ").append(this.getUpdatedAt()).append(",");
        }
        if (this.getShareInvitationId() != null) {
            sb.append("ShareInvitationId: ").append(this.getShareInvitationId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Profile)) {
            return false;
        }
        Profile other = (Profile)obj;
        if (other.getProfileArn() == null ^ this.getProfileArn() == null) {
            return false;
        }
        if (other.getProfileArn() != null && !other.getProfileArn().equals(this.getProfileArn())) {
            return false;
        }
        if (other.getProfileVersion() == null ^ this.getProfileVersion() == null) {
            return false;
        }
        if (other.getProfileVersion() != null && !other.getProfileVersion().equals(this.getProfileVersion())) {
            return false;
        }
        if (other.getProfileName() == null ^ this.getProfileName() == null) {
            return false;
        }
        if (other.getProfileName() != null && !other.getProfileName().equals(this.getProfileName())) {
            return false;
        }
        if (other.getProfileDescription() == null ^ this.getProfileDescription() == null) {
            return false;
        }
        if (other.getProfileDescription() != null && !other.getProfileDescription().equals(this.getProfileDescription())) {
            return false;
        }
        if (other.getProfileQuestions() == null ^ this.getProfileQuestions() == null) {
            return false;
        }
        if (other.getProfileQuestions() != null && !other.getProfileQuestions().equals(this.getProfileQuestions())) {
            return false;
        }
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getUpdatedAt() == null ^ this.getUpdatedAt() == null) {
            return false;
        }
        if (other.getUpdatedAt() != null && !other.getUpdatedAt().equals(this.getUpdatedAt())) {
            return false;
        }
        if (other.getShareInvitationId() == null ^ this.getShareInvitationId() == null) {
            return false;
        }
        if (other.getShareInvitationId() != null && !other.getShareInvitationId().equals(this.getShareInvitationId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProfileArn() == null ? 0 : this.getProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.getProfileVersion() == null ? 0 : this.getProfileVersion().hashCode());
        hashCode = 31 * hashCode + (this.getProfileName() == null ? 0 : this.getProfileName().hashCode());
        hashCode = 31 * hashCode + (this.getProfileDescription() == null ? 0 : this.getProfileDescription().hashCode());
        hashCode = 31 * hashCode + (this.getProfileQuestions() == null ? 0 : this.getProfileQuestions().hashCode());
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getUpdatedAt() == null ? 0 : this.getUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getShareInvitationId() == null ? 0 : this.getShareInvitationId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Profile clone() {
        try {
            return (Profile)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProfileMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

