/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wellarchitected.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.wellarchitected.model.QuestionMetric;
import java.util.List;

@SdkInternalApi
public class QuestionMetricMarshaller {
    private static final MarshallingInfo<String> QUESTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QuestionId").build();
    private static final MarshallingInfo<String> RISK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Risk").build();
    private static final MarshallingInfo<List> BESTPRACTICES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BestPractices").build();
    private static final QuestionMetricMarshaller instance = new QuestionMetricMarshaller();

    public static QuestionMetricMarshaller getInstance() {
        return instance;
    }

    public void marshall(QuestionMetric questionMetric, ProtocolMarshaller protocolMarshaller) {
        if (questionMetric == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)questionMetric.getQuestionId(), QUESTIONID_BINDING);
            protocolMarshaller.marshall((Object)questionMetric.getRisk(), RISK_BINDING);
            protocolMarshaller.marshall(questionMetric.getBestPractices(), BESTPRACTICES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

