/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.wellarchitected;

import javax.annotation.Generated;

import com.amazonaws.services.wellarchitected.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSWellArchitected}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSWellArchitected implements AWSWellArchitected {

    protected AbstractAWSWellArchitected() {
    }

    @Override
    public AssociateLensesResult associateLenses(AssociateLensesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateProfilesResult associateProfiles(AssociateProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLensShareResult createLensShare(CreateLensShareRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLensVersionResult createLensVersion(CreateLensVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMilestoneResult createMilestone(CreateMilestoneRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProfileResult createProfile(CreateProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProfileShareResult createProfileShare(CreateProfileShareRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkloadResult createWorkload(CreateWorkloadRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkloadShareResult createWorkloadShare(CreateWorkloadShareRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLensResult deleteLens(DeleteLensRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLensShareResult deleteLensShare(DeleteLensShareRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProfileResult deleteProfile(DeleteProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProfileShareResult deleteProfileShare(DeleteProfileShareRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkloadResult deleteWorkload(DeleteWorkloadRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkloadShareResult deleteWorkloadShare(DeleteWorkloadShareRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateLensesResult disassociateLenses(DisassociateLensesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateProfilesResult disassociateProfiles(DisassociateProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ExportLensResult exportLens(ExportLensRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAnswerResult getAnswer(GetAnswerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConsolidatedReportResult getConsolidatedReport(GetConsolidatedReportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLensResult getLens(GetLensRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLensReviewResult getLensReview(GetLensReviewRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLensReviewReportResult getLensReviewReport(GetLensReviewReportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLensVersionDifferenceResult getLensVersionDifference(GetLensVersionDifferenceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMilestoneResult getMilestone(GetMilestoneRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetProfileResult getProfile(GetProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetProfileTemplateResult getProfileTemplate(GetProfileTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWorkloadResult getWorkload(GetWorkloadRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ImportLensResult importLens(ImportLensRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAnswersResult listAnswers(ListAnswersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCheckDetailsResult listCheckDetails(ListCheckDetailsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCheckSummariesResult listCheckSummaries(ListCheckSummariesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLensReviewImprovementsResult listLensReviewImprovements(ListLensReviewImprovementsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLensReviewsResult listLensReviews(ListLensReviewsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLensSharesResult listLensShares(ListLensSharesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLensesResult listLenses(ListLensesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMilestonesResult listMilestones(ListMilestonesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNotificationsResult listNotifications(ListNotificationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProfileNotificationsResult listProfileNotifications(ListProfileNotificationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProfileSharesResult listProfileShares(ListProfileSharesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProfilesResult listProfiles(ListProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListShareInvitationsResult listShareInvitations(ListShareInvitationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWorkloadSharesResult listWorkloadShares(ListWorkloadSharesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWorkloadsResult listWorkloads(ListWorkloadsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAnswerResult updateAnswer(UpdateAnswerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGlobalSettingsResult updateGlobalSettings(UpdateGlobalSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateLensReviewResult updateLensReview(UpdateLensReviewRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProfileResult updateProfile(UpdateProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateShareInvitationResult updateShareInvitation(UpdateShareInvitationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkloadResult updateWorkload(UpdateWorkloadRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkloadShareResult updateWorkloadShare(UpdateWorkloadShareRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpgradeLensReviewResult upgradeLensReview(UpgradeLensReviewRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpgradeProfileVersionResult upgradeProfileVersion(UpgradeProfileVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
