/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wellarchitected.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wellarchitected.model.QuestionMetric;
import com.amazonaws.services.wellarchitected.model.transform.PillarMetricMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PillarMetric
implements Serializable,
Cloneable,
StructuredPojo {
    private String pillarId;
    private Map<String, Integer> riskCounts;
    private List<QuestionMetric> questions;

    public void setPillarId(String pillarId) {
        this.pillarId = pillarId;
    }

    public String getPillarId() {
        return this.pillarId;
    }

    public PillarMetric withPillarId(String pillarId) {
        this.setPillarId(pillarId);
        return this;
    }

    public Map<String, Integer> getRiskCounts() {
        return this.riskCounts;
    }

    public void setRiskCounts(Map<String, Integer> riskCounts) {
        this.riskCounts = riskCounts;
    }

    public PillarMetric withRiskCounts(Map<String, Integer> riskCounts) {
        this.setRiskCounts(riskCounts);
        return this;
    }

    public PillarMetric addRiskCountsEntry(String key, Integer value) {
        if (null == this.riskCounts) {
            this.riskCounts = new HashMap<String, Integer>();
        }
        if (this.riskCounts.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.riskCounts.put(key, value);
        return this;
    }

    public PillarMetric clearRiskCountsEntries() {
        this.riskCounts = null;
        return this;
    }

    public List<QuestionMetric> getQuestions() {
        return this.questions;
    }

    public void setQuestions(Collection<QuestionMetric> questions) {
        if (questions == null) {
            this.questions = null;
            return;
        }
        this.questions = new ArrayList<QuestionMetric>(questions);
    }

    public PillarMetric withQuestions(QuestionMetric ... questions) {
        if (this.questions == null) {
            this.setQuestions(new ArrayList<QuestionMetric>(questions.length));
        }
        for (QuestionMetric ele : questions) {
            this.questions.add(ele);
        }
        return this;
    }

    public PillarMetric withQuestions(Collection<QuestionMetric> questions) {
        this.setQuestions(questions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPillarId() != null) {
            sb.append("PillarId: ").append(this.getPillarId()).append(",");
        }
        if (this.getRiskCounts() != null) {
            sb.append("RiskCounts: ").append(this.getRiskCounts()).append(",");
        }
        if (this.getQuestions() != null) {
            sb.append("Questions: ").append(this.getQuestions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PillarMetric)) {
            return false;
        }
        PillarMetric other = (PillarMetric)obj;
        if (other.getPillarId() == null ^ this.getPillarId() == null) {
            return false;
        }
        if (other.getPillarId() != null && !other.getPillarId().equals(this.getPillarId())) {
            return false;
        }
        if (other.getRiskCounts() == null ^ this.getRiskCounts() == null) {
            return false;
        }
        if (other.getRiskCounts() != null && !other.getRiskCounts().equals(this.getRiskCounts())) {
            return false;
        }
        if (other.getQuestions() == null ^ this.getQuestions() == null) {
            return false;
        }
        return other.getQuestions() == null || other.getQuestions().equals(this.getQuestions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPillarId() == null ? 0 : this.getPillarId().hashCode());
        hashCode = 31 * hashCode + (this.getRiskCounts() == null ? 0 : this.getRiskCounts().hashCode());
        hashCode = 31 * hashCode + (this.getQuestions() == null ? 0 : this.getQuestions().hashCode());
        return hashCode;
    }

    public PillarMetric clone() {
        try {
            return (PillarMetric)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PillarMetricMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

