/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wellarchitected.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wellarchitected.model.AnswerReason;
import com.amazonaws.services.wellarchitected.model.Choice;
import com.amazonaws.services.wellarchitected.model.ChoiceAnswer;
import com.amazonaws.services.wellarchitected.model.Risk;
import com.amazonaws.services.wellarchitected.model.transform.AnswerMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Answer
implements Serializable,
Cloneable,
StructuredPojo {
    private String questionId;
    private String pillarId;
    private String questionTitle;
    private String questionDescription;
    private String improvementPlanUrl;
    private String helpfulResourceUrl;
    private List<Choice> choices;
    private List<String> selectedChoices;
    private List<ChoiceAnswer> choiceAnswers;
    private Boolean isApplicable;
    private String risk;
    private String notes;
    private String reason;

    public void setQuestionId(String questionId) {
        this.questionId = questionId;
    }

    public String getQuestionId() {
        return this.questionId;
    }

    public Answer withQuestionId(String questionId) {
        this.setQuestionId(questionId);
        return this;
    }

    public void setPillarId(String pillarId) {
        this.pillarId = pillarId;
    }

    public String getPillarId() {
        return this.pillarId;
    }

    public Answer withPillarId(String pillarId) {
        this.setPillarId(pillarId);
        return this;
    }

    public void setQuestionTitle(String questionTitle) {
        this.questionTitle = questionTitle;
    }

    public String getQuestionTitle() {
        return this.questionTitle;
    }

    public Answer withQuestionTitle(String questionTitle) {
        this.setQuestionTitle(questionTitle);
        return this;
    }

    public void setQuestionDescription(String questionDescription) {
        this.questionDescription = questionDescription;
    }

    public String getQuestionDescription() {
        return this.questionDescription;
    }

    public Answer withQuestionDescription(String questionDescription) {
        this.setQuestionDescription(questionDescription);
        return this;
    }

    public void setImprovementPlanUrl(String improvementPlanUrl) {
        this.improvementPlanUrl = improvementPlanUrl;
    }

    public String getImprovementPlanUrl() {
        return this.improvementPlanUrl;
    }

    public Answer withImprovementPlanUrl(String improvementPlanUrl) {
        this.setImprovementPlanUrl(improvementPlanUrl);
        return this;
    }

    public void setHelpfulResourceUrl(String helpfulResourceUrl) {
        this.helpfulResourceUrl = helpfulResourceUrl;
    }

    public String getHelpfulResourceUrl() {
        return this.helpfulResourceUrl;
    }

    public Answer withHelpfulResourceUrl(String helpfulResourceUrl) {
        this.setHelpfulResourceUrl(helpfulResourceUrl);
        return this;
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    public void setChoices(Collection<Choice> choices) {
        if (choices == null) {
            this.choices = null;
            return;
        }
        this.choices = new ArrayList<Choice>(choices);
    }

    public Answer withChoices(Choice ... choices) {
        if (this.choices == null) {
            this.setChoices(new ArrayList<Choice>(choices.length));
        }
        for (Choice ele : choices) {
            this.choices.add(ele);
        }
        return this;
    }

    public Answer withChoices(Collection<Choice> choices) {
        this.setChoices(choices);
        return this;
    }

    public List<String> getSelectedChoices() {
        return this.selectedChoices;
    }

    public void setSelectedChoices(Collection<String> selectedChoices) {
        if (selectedChoices == null) {
            this.selectedChoices = null;
            return;
        }
        this.selectedChoices = new ArrayList<String>(selectedChoices);
    }

    public Answer withSelectedChoices(String ... selectedChoices) {
        if (this.selectedChoices == null) {
            this.setSelectedChoices(new ArrayList<String>(selectedChoices.length));
        }
        for (String ele : selectedChoices) {
            this.selectedChoices.add(ele);
        }
        return this;
    }

    public Answer withSelectedChoices(Collection<String> selectedChoices) {
        this.setSelectedChoices(selectedChoices);
        return this;
    }

    public List<ChoiceAnswer> getChoiceAnswers() {
        return this.choiceAnswers;
    }

    public void setChoiceAnswers(Collection<ChoiceAnswer> choiceAnswers) {
        if (choiceAnswers == null) {
            this.choiceAnswers = null;
            return;
        }
        this.choiceAnswers = new ArrayList<ChoiceAnswer>(choiceAnswers);
    }

    public Answer withChoiceAnswers(ChoiceAnswer ... choiceAnswers) {
        if (this.choiceAnswers == null) {
            this.setChoiceAnswers(new ArrayList<ChoiceAnswer>(choiceAnswers.length));
        }
        for (ChoiceAnswer ele : choiceAnswers) {
            this.choiceAnswers.add(ele);
        }
        return this;
    }

    public Answer withChoiceAnswers(Collection<ChoiceAnswer> choiceAnswers) {
        this.setChoiceAnswers(choiceAnswers);
        return this;
    }

    public void setIsApplicable(Boolean isApplicable) {
        this.isApplicable = isApplicable;
    }

    public Boolean getIsApplicable() {
        return this.isApplicable;
    }

    public Answer withIsApplicable(Boolean isApplicable) {
        this.setIsApplicable(isApplicable);
        return this;
    }

    public Boolean isApplicable() {
        return this.isApplicable;
    }

    public void setRisk(String risk) {
        this.risk = risk;
    }

    public String getRisk() {
        return this.risk;
    }

    public Answer withRisk(String risk) {
        this.setRisk(risk);
        return this;
    }

    public Answer withRisk(Risk risk) {
        this.risk = risk.toString();
        return this;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getNotes() {
        return this.notes;
    }

    public Answer withNotes(String notes) {
        this.setNotes(notes);
        return this;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getReason() {
        return this.reason;
    }

    public Answer withReason(String reason) {
        this.setReason(reason);
        return this;
    }

    public Answer withReason(AnswerReason reason) {
        this.reason = reason.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQuestionId() != null) {
            sb.append("QuestionId: ").append(this.getQuestionId()).append(",");
        }
        if (this.getPillarId() != null) {
            sb.append("PillarId: ").append(this.getPillarId()).append(",");
        }
        if (this.getQuestionTitle() != null) {
            sb.append("QuestionTitle: ").append(this.getQuestionTitle()).append(",");
        }
        if (this.getQuestionDescription() != null) {
            sb.append("QuestionDescription: ").append(this.getQuestionDescription()).append(",");
        }
        if (this.getImprovementPlanUrl() != null) {
            sb.append("ImprovementPlanUrl: ").append(this.getImprovementPlanUrl()).append(",");
        }
        if (this.getHelpfulResourceUrl() != null) {
            sb.append("HelpfulResourceUrl: ").append(this.getHelpfulResourceUrl()).append(",");
        }
        if (this.getChoices() != null) {
            sb.append("Choices: ").append(this.getChoices()).append(",");
        }
        if (this.getSelectedChoices() != null) {
            sb.append("SelectedChoices: ").append(this.getSelectedChoices()).append(",");
        }
        if (this.getChoiceAnswers() != null) {
            sb.append("ChoiceAnswers: ").append(this.getChoiceAnswers()).append(",");
        }
        if (this.getIsApplicable() != null) {
            sb.append("IsApplicable: ").append(this.getIsApplicable()).append(",");
        }
        if (this.getRisk() != null) {
            sb.append("Risk: ").append(this.getRisk()).append(",");
        }
        if (this.getNotes() != null) {
            sb.append("Notes: ").append(this.getNotes()).append(",");
        }
        if (this.getReason() != null) {
            sb.append("Reason: ").append(this.getReason());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Answer)) {
            return false;
        }
        Answer other = (Answer)obj;
        if (other.getQuestionId() == null ^ this.getQuestionId() == null) {
            return false;
        }
        if (other.getQuestionId() != null && !other.getQuestionId().equals(this.getQuestionId())) {
            return false;
        }
        if (other.getPillarId() == null ^ this.getPillarId() == null) {
            return false;
        }
        if (other.getPillarId() != null && !other.getPillarId().equals(this.getPillarId())) {
            return false;
        }
        if (other.getQuestionTitle() == null ^ this.getQuestionTitle() == null) {
            return false;
        }
        if (other.getQuestionTitle() != null && !other.getQuestionTitle().equals(this.getQuestionTitle())) {
            return false;
        }
        if (other.getQuestionDescription() == null ^ this.getQuestionDescription() == null) {
            return false;
        }
        if (other.getQuestionDescription() != null && !other.getQuestionDescription().equals(this.getQuestionDescription())) {
            return false;
        }
        if (other.getImprovementPlanUrl() == null ^ this.getImprovementPlanUrl() == null) {
            return false;
        }
        if (other.getImprovementPlanUrl() != null && !other.getImprovementPlanUrl().equals(this.getImprovementPlanUrl())) {
            return false;
        }
        if (other.getHelpfulResourceUrl() == null ^ this.getHelpfulResourceUrl() == null) {
            return false;
        }
        if (other.getHelpfulResourceUrl() != null && !other.getHelpfulResourceUrl().equals(this.getHelpfulResourceUrl())) {
            return false;
        }
        if (other.getChoices() == null ^ this.getChoices() == null) {
            return false;
        }
        if (other.getChoices() != null && !other.getChoices().equals(this.getChoices())) {
            return false;
        }
        if (other.getSelectedChoices() == null ^ this.getSelectedChoices() == null) {
            return false;
        }
        if (other.getSelectedChoices() != null && !other.getSelectedChoices().equals(this.getSelectedChoices())) {
            return false;
        }
        if (other.getChoiceAnswers() == null ^ this.getChoiceAnswers() == null) {
            return false;
        }
        if (other.getChoiceAnswers() != null && !other.getChoiceAnswers().equals(this.getChoiceAnswers())) {
            return false;
        }
        if (other.getIsApplicable() == null ^ this.getIsApplicable() == null) {
            return false;
        }
        if (other.getIsApplicable() != null && !other.getIsApplicable().equals(this.getIsApplicable())) {
            return false;
        }
        if (other.getRisk() == null ^ this.getRisk() == null) {
            return false;
        }
        if (other.getRisk() != null && !other.getRisk().equals(this.getRisk())) {
            return false;
        }
        if (other.getNotes() == null ^ this.getNotes() == null) {
            return false;
        }
        if (other.getNotes() != null && !other.getNotes().equals(this.getNotes())) {
            return false;
        }
        if (other.getReason() == null ^ this.getReason() == null) {
            return false;
        }
        return other.getReason() == null || other.getReason().equals(this.getReason());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQuestionId() == null ? 0 : this.getQuestionId().hashCode());
        hashCode = 31 * hashCode + (this.getPillarId() == null ? 0 : this.getPillarId().hashCode());
        hashCode = 31 * hashCode + (this.getQuestionTitle() == null ? 0 : this.getQuestionTitle().hashCode());
        hashCode = 31 * hashCode + (this.getQuestionDescription() == null ? 0 : this.getQuestionDescription().hashCode());
        hashCode = 31 * hashCode + (this.getImprovementPlanUrl() == null ? 0 : this.getImprovementPlanUrl().hashCode());
        hashCode = 31 * hashCode + (this.getHelpfulResourceUrl() == null ? 0 : this.getHelpfulResourceUrl().hashCode());
        hashCode = 31 * hashCode + (this.getChoices() == null ? 0 : this.getChoices().hashCode());
        hashCode = 31 * hashCode + (this.getSelectedChoices() == null ? 0 : this.getSelectedChoices().hashCode());
        hashCode = 31 * hashCode + (this.getChoiceAnswers() == null ? 0 : this.getChoiceAnswers().hashCode());
        hashCode = 31 * hashCode + (this.getIsApplicable() == null ? 0 : this.getIsApplicable().hashCode());
        hashCode = 31 * hashCode + (this.getRisk() == null ? 0 : this.getRisk().hashCode());
        hashCode = 31 * hashCode + (this.getNotes() == null ? 0 : this.getNotes().hashCode());
        hashCode = 31 * hashCode + (this.getReason() == null ? 0 : this.getReason().hashCode());
        return hashCode;
    }

    public Answer clone() {
        try {
            return (Answer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AnswerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

