/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.transform.ResponseInspectionHeaderMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResponseInspectionHeader
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<String> successValues;
    private List<String> failureValues;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ResponseInspectionHeader withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getSuccessValues() {
        return this.successValues;
    }

    public void setSuccessValues(Collection<String> successValues) {
        if (successValues == null) {
            this.successValues = null;
            return;
        }
        this.successValues = new ArrayList<String>(successValues);
    }

    public ResponseInspectionHeader withSuccessValues(String ... successValues) {
        if (this.successValues == null) {
            this.setSuccessValues(new ArrayList<String>(successValues.length));
        }
        for (String ele : successValues) {
            this.successValues.add(ele);
        }
        return this;
    }

    public ResponseInspectionHeader withSuccessValues(Collection<String> successValues) {
        this.setSuccessValues(successValues);
        return this;
    }

    public List<String> getFailureValues() {
        return this.failureValues;
    }

    public void setFailureValues(Collection<String> failureValues) {
        if (failureValues == null) {
            this.failureValues = null;
            return;
        }
        this.failureValues = new ArrayList<String>(failureValues);
    }

    public ResponseInspectionHeader withFailureValues(String ... failureValues) {
        if (this.failureValues == null) {
            this.setFailureValues(new ArrayList<String>(failureValues.length));
        }
        for (String ele : failureValues) {
            this.failureValues.add(ele);
        }
        return this;
    }

    public ResponseInspectionHeader withFailureValues(Collection<String> failureValues) {
        this.setFailureValues(failureValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSuccessValues() != null) {
            sb.append("SuccessValues: ").append(this.getSuccessValues()).append(",");
        }
        if (this.getFailureValues() != null) {
            sb.append("FailureValues: ").append(this.getFailureValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseInspectionHeader)) {
            return false;
        }
        ResponseInspectionHeader other = (ResponseInspectionHeader)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSuccessValues() == null ^ this.getSuccessValues() == null) {
            return false;
        }
        if (other.getSuccessValues() != null && !other.getSuccessValues().equals(this.getSuccessValues())) {
            return false;
        }
        if (other.getFailureValues() == null ^ this.getFailureValues() == null) {
            return false;
        }
        return other.getFailureValues() == null || other.getFailureValues().equals(this.getFailureValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSuccessValues() == null ? 0 : this.getSuccessValues().hashCode());
        hashCode = 31 * hashCode + (this.getFailureValues() == null ? 0 : this.getFailureValues().hashCode());
        return hashCode;
    }

    public ResponseInspectionHeader clone() {
        try {
            return (ResponseInspectionHeader)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResponseInspectionHeaderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

