/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.transform.APIKeySummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class APIKeySummary
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> tokenDomains;
    private String aPIKey;
    private Date creationTimestamp;
    private Integer version;

    public List<String> getTokenDomains() {
        return this.tokenDomains;
    }

    public void setTokenDomains(Collection<String> tokenDomains) {
        if (tokenDomains == null) {
            this.tokenDomains = null;
            return;
        }
        this.tokenDomains = new ArrayList<String>(tokenDomains);
    }

    public APIKeySummary withTokenDomains(String ... tokenDomains) {
        if (this.tokenDomains == null) {
            this.setTokenDomains(new ArrayList<String>(tokenDomains.length));
        }
        for (String ele : tokenDomains) {
            this.tokenDomains.add(ele);
        }
        return this;
    }

    public APIKeySummary withTokenDomains(Collection<String> tokenDomains) {
        this.setTokenDomains(tokenDomains);
        return this;
    }

    public void setAPIKey(String aPIKey) {
        this.aPIKey = aPIKey;
    }

    public String getAPIKey() {
        return this.aPIKey;
    }

    public APIKeySummary withAPIKey(String aPIKey) {
        this.setAPIKey(aPIKey);
        return this;
    }

    public void setCreationTimestamp(Date creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public Date getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public APIKeySummary withCreationTimestamp(Date creationTimestamp) {
        this.setCreationTimestamp(creationTimestamp);
        return this;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Integer getVersion() {
        return this.version;
    }

    public APIKeySummary withVersion(Integer version) {
        this.setVersion(version);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTokenDomains() != null) {
            sb.append("TokenDomains: ").append(this.getTokenDomains()).append(",");
        }
        if (this.getAPIKey() != null) {
            sb.append("APIKey: ").append(this.getAPIKey()).append(",");
        }
        if (this.getCreationTimestamp() != null) {
            sb.append("CreationTimestamp: ").append(this.getCreationTimestamp()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APIKeySummary)) {
            return false;
        }
        APIKeySummary other = (APIKeySummary)obj;
        if (other.getTokenDomains() == null ^ this.getTokenDomains() == null) {
            return false;
        }
        if (other.getTokenDomains() != null && !other.getTokenDomains().equals(this.getTokenDomains())) {
            return false;
        }
        if (other.getAPIKey() == null ^ this.getAPIKey() == null) {
            return false;
        }
        if (other.getAPIKey() != null && !other.getAPIKey().equals(this.getAPIKey())) {
            return false;
        }
        if (other.getCreationTimestamp() == null ^ this.getCreationTimestamp() == null) {
            return false;
        }
        if (other.getCreationTimestamp() != null && !other.getCreationTimestamp().equals(this.getCreationTimestamp())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        return other.getVersion() == null || other.getVersion().equals(this.getVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTokenDomains() == null ? 0 : this.getTokenDomains().hashCode());
        hashCode = 31 * hashCode + (this.getAPIKey() == null ? 0 : this.getAPIKey().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTimestamp() == null ? 0 : this.getCreationTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        return hashCode;
    }

    public APIKeySummary clone() {
        try {
            return (APIKeySummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        APIKeySummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

