/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.wafv2.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Contains zero or more IP addresses or blocks of IP addresses specified in Classless Inter-Domain Routing (CIDR)
 * notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0. For information about CIDR notation, see the
 * Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain
 * Routing</a>.
 * </p>
 * <p>
 * WAF assigns an ARN to each <code>IPSet</code> that you create. To use an IP set in a rule, you provide the ARN to the
 * <a>Rule</a> statement <a>IPSetReferenceStatement</a>.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/IPSet" target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class IPSet implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.
     * </p>
     */
    private String name;
    /**
     * <p>
     * A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it
     * to operations like update and delete.
     * </p>
     */
    private String id;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the entity.
     * </p>
     */
    private String aRN;
    /**
     * <p>
     * A description of the IP set that helps with identification.
     * </p>
     */
    private String description;
    /**
     * <p>
     * The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>.
     * </p>
     */
    private String iPAddressVersion;
    /**
     * <p>
     * Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses that you want WAF
     * to inspect for in incoming requests. All addresses must be specified using Classless Inter-Domain Routing (CIDR)
     * notation. WAF supports all IPv4 and IPv6 CIDR ranges except for <code>/0</code>.
     * </p>
     * <p>
     * Example address strings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify
     * <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to
     * 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about CIDR notation, see the Wikipedia entry <a
     * href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
     * </p>
     * <p>
     * Example JSON <code>Addresses</code> specifications:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Empty array: <code>"Addresses": []</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Array with one address: <code>"Addresses": ["192.0.2.44/32"]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Array with three addresses: <code>"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * INVALID specification: <code>"Addresses": [""]</code> INVALID
     * </p>
     * </li>
     * </ul>
     */
    private java.util.List<String> addresses;

    /**
     * <p>
     * The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.
     * </p>
     * 
     * @param name
     *        The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.
     * </p>
     * 
     * @return The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.
     * </p>
     * 
     * @param name
     *        The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IPSet withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it
     * to operations like update and delete.
     * </p>
     * 
     * @param id
     *        A unique identifier for the set. This ID is returned in the responses to create and list commands. You
     *        provide it to operations like update and delete.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it
     * to operations like update and delete.
     * </p>
     * 
     * @return A unique identifier for the set. This ID is returned in the responses to create and list commands. You
     *         provide it to operations like update and delete.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it
     * to operations like update and delete.
     * </p>
     * 
     * @param id
     *        A unique identifier for the set. This ID is returned in the responses to create and list commands. You
     *        provide it to operations like update and delete.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IPSet withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the entity.
     * </p>
     * 
     * @param aRN
     *        The Amazon Resource Name (ARN) of the entity.
     */

    public void setARN(String aRN) {
        this.aRN = aRN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the entity.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the entity.
     */

    public String getARN() {
        return this.aRN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the entity.
     * </p>
     * 
     * @param aRN
     *        The Amazon Resource Name (ARN) of the entity.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IPSet withARN(String aRN) {
        setARN(aRN);
        return this;
    }

    /**
     * <p>
     * A description of the IP set that helps with identification.
     * </p>
     * 
     * @param description
     *        A description of the IP set that helps with identification.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * A description of the IP set that helps with identification.
     * </p>
     * 
     * @return A description of the IP set that helps with identification.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * A description of the IP set that helps with identification.
     * </p>
     * 
     * @param description
     *        A description of the IP set that helps with identification.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IPSet withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>.
     * </p>
     * 
     * @param iPAddressVersion
     *        The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>.
     * @see IPAddressVersion
     */

    public void setIPAddressVersion(String iPAddressVersion) {
        this.iPAddressVersion = iPAddressVersion;
    }

    /**
     * <p>
     * The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>.
     * </p>
     * 
     * @return The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>.
     * @see IPAddressVersion
     */

    public String getIPAddressVersion() {
        return this.iPAddressVersion;
    }

    /**
     * <p>
     * The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>.
     * </p>
     * 
     * @param iPAddressVersion
     *        The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see IPAddressVersion
     */

    public IPSet withIPAddressVersion(String iPAddressVersion) {
        setIPAddressVersion(iPAddressVersion);
        return this;
    }

    /**
     * <p>
     * The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>.
     * </p>
     * 
     * @param iPAddressVersion
     *        The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see IPAddressVersion
     */

    public IPSet withIPAddressVersion(IPAddressVersion iPAddressVersion) {
        this.iPAddressVersion = iPAddressVersion.toString();
        return this;
    }

    /**
     * <p>
     * Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses that you want WAF
     * to inspect for in incoming requests. All addresses must be specified using Classless Inter-Domain Routing (CIDR)
     * notation. WAF supports all IPv4 and IPv6 CIDR ranges except for <code>/0</code>.
     * </p>
     * <p>
     * Example address strings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify
     * <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to
     * 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about CIDR notation, see the Wikipedia entry <a
     * href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
     * </p>
     * <p>
     * Example JSON <code>Addresses</code> specifications:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Empty array: <code>"Addresses": []</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Array with one address: <code>"Addresses": ["192.0.2.44/32"]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Array with three addresses: <code>"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * INVALID specification: <code>"Addresses": [""]</code> INVALID
     * </p>
     * </li>
     * </ul>
     * 
     * @return Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses that you
     *         want WAF to inspect for in incoming requests. All addresses must be specified using Classless
     *         Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for
     *         <code>/0</code>. </p>
     *         <p>
     *         Example address strings:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify
     *         <code>192.0.2.0/24</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify
     *         <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to
     *         1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about CIDR notation, see the Wikipedia entry <a
     *         href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
     *         </p>
     *         <p>
     *         Example JSON <code>Addresses</code> specifications:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Empty array: <code>"Addresses": []</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Array with one address: <code>"Addresses": ["192.0.2.44/32"]</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Array with three addresses: <code>"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID specification: <code>"Addresses": [""]</code> INVALID
     *         </p>
     *         </li>
     */

    public java.util.List<String> getAddresses() {
        return addresses;
    }

    /**
     * <p>
     * Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses that you want WAF
     * to inspect for in incoming requests. All addresses must be specified using Classless Inter-Domain Routing (CIDR)
     * notation. WAF supports all IPv4 and IPv6 CIDR ranges except for <code>/0</code>.
     * </p>
     * <p>
     * Example address strings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify
     * <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to
     * 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about CIDR notation, see the Wikipedia entry <a
     * href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
     * </p>
     * <p>
     * Example JSON <code>Addresses</code> specifications:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Empty array: <code>"Addresses": []</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Array with one address: <code>"Addresses": ["192.0.2.44/32"]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Array with three addresses: <code>"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * INVALID specification: <code>"Addresses": [""]</code> INVALID
     * </p>
     * </li>
     * </ul>
     * 
     * @param addresses
     *        Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses that you
     *        want WAF to inspect for in incoming requests. All addresses must be specified using Classless Inter-Domain
     *        Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for <code>/0</code>. </p>
     *        <p>
     *        Example address strings:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        For requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        For requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify
     *        <code>192.0.2.0/24</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        For requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify
     *        <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        For requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to
     *        1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        For more information about CIDR notation, see the Wikipedia entry <a
     *        href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
     *        </p>
     *        <p>
     *        Example JSON <code>Addresses</code> specifications:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Empty array: <code>"Addresses": []</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Array with one address: <code>"Addresses": ["192.0.2.44/32"]</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Array with three addresses: <code>"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        INVALID specification: <code>"Addresses": [""]</code> INVALID
     *        </p>
     *        </li>
     */

    public void setAddresses(java.util.Collection<String> addresses) {
        if (addresses == null) {
            this.addresses = null;
            return;
        }

        this.addresses = new java.util.ArrayList<String>(addresses);
    }

    /**
     * <p>
     * Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses that you want WAF
     * to inspect for in incoming requests. All addresses must be specified using Classless Inter-Domain Routing (CIDR)
     * notation. WAF supports all IPv4 and IPv6 CIDR ranges except for <code>/0</code>.
     * </p>
     * <p>
     * Example address strings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify
     * <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to
     * 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about CIDR notation, see the Wikipedia entry <a
     * href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
     * </p>
     * <p>
     * Example JSON <code>Addresses</code> specifications:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Empty array: <code>"Addresses": []</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Array with one address: <code>"Addresses": ["192.0.2.44/32"]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Array with three addresses: <code>"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * INVALID specification: <code>"Addresses": [""]</code> INVALID
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAddresses(java.util.Collection)} or {@link #withAddresses(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param addresses
     *        Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses that you
     *        want WAF to inspect for in incoming requests. All addresses must be specified using Classless Inter-Domain
     *        Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for <code>/0</code>. </p>
     *        <p>
     *        Example address strings:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        For requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        For requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify
     *        <code>192.0.2.0/24</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        For requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify
     *        <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        For requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to
     *        1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        For more information about CIDR notation, see the Wikipedia entry <a
     *        href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
     *        </p>
     *        <p>
     *        Example JSON <code>Addresses</code> specifications:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Empty array: <code>"Addresses": []</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Array with one address: <code>"Addresses": ["192.0.2.44/32"]</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Array with three addresses: <code>"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        INVALID specification: <code>"Addresses": [""]</code> INVALID
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IPSet withAddresses(String... addresses) {
        if (this.addresses == null) {
            setAddresses(new java.util.ArrayList<String>(addresses.length));
        }
        for (String ele : addresses) {
            this.addresses.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses that you want WAF
     * to inspect for in incoming requests. All addresses must be specified using Classless Inter-Domain Routing (CIDR)
     * notation. WAF supports all IPv4 and IPv6 CIDR ranges except for <code>/0</code>.
     * </p>
     * <p>
     * Example address strings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify
     * <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to
     * 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about CIDR notation, see the Wikipedia entry <a
     * href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
     * </p>
     * <p>
     * Example JSON <code>Addresses</code> specifications:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Empty array: <code>"Addresses": []</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Array with one address: <code>"Addresses": ["192.0.2.44/32"]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Array with three addresses: <code>"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * INVALID specification: <code>"Addresses": [""]</code> INVALID
     * </p>
     * </li>
     * </ul>
     * 
     * @param addresses
     *        Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses that you
     *        want WAF to inspect for in incoming requests. All addresses must be specified using Classless Inter-Domain
     *        Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for <code>/0</code>. </p>
     *        <p>
     *        Example address strings:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        For requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        For requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify
     *        <code>192.0.2.0/24</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        For requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify
     *        <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        For requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to
     *        1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        For more information about CIDR notation, see the Wikipedia entry <a
     *        href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
     *        </p>
     *        <p>
     *        Example JSON <code>Addresses</code> specifications:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Empty array: <code>"Addresses": []</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Array with one address: <code>"Addresses": ["192.0.2.44/32"]</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Array with three addresses: <code>"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        INVALID specification: <code>"Addresses": [""]</code> INVALID
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IPSet withAddresses(java.util.Collection<String> addresses) {
        setAddresses(addresses);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getARN() != null)
            sb.append("ARN: ").append(getARN()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getIPAddressVersion() != null)
            sb.append("IPAddressVersion: ").append(getIPAddressVersion()).append(",");
        if (getAddresses() != null)
            sb.append("Addresses: ").append(getAddresses());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof IPSet == false)
            return false;
        IPSet other = (IPSet) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getARN() == null ^ this.getARN() == null)
            return false;
        if (other.getARN() != null && other.getARN().equals(this.getARN()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getIPAddressVersion() == null ^ this.getIPAddressVersion() == null)
            return false;
        if (other.getIPAddressVersion() != null && other.getIPAddressVersion().equals(this.getIPAddressVersion()) == false)
            return false;
        if (other.getAddresses() == null ^ this.getAddresses() == null)
            return false;
        if (other.getAddresses() != null && other.getAddresses().equals(this.getAddresses()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getARN() == null) ? 0 : getARN().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getIPAddressVersion() == null) ? 0 : getIPAddressVersion().hashCode());
        hashCode = prime * hashCode + ((getAddresses() == null) ? 0 : getAddresses().hashCode());
        return hashCode;
    }

    @Override
    public IPSet clone() {
        try {
            return (IPSet) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.wafv2.model.transform.IPSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
