/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.verifiedpermissions;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.verifiedpermissions.AmazonVerifiedPermissions;
import com.amazonaws.services.verifiedpermissions.AmazonVerifiedPermissionsClientBuilder;
import com.amazonaws.services.verifiedpermissions.model.AmazonVerifiedPermissionsException;
import com.amazonaws.services.verifiedpermissions.model.BatchIsAuthorizedRequest;
import com.amazonaws.services.verifiedpermissions.model.BatchIsAuthorizedResult;
import com.amazonaws.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenRequest;
import com.amazonaws.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenResult;
import com.amazonaws.services.verifiedpermissions.model.CreateIdentitySourceRequest;
import com.amazonaws.services.verifiedpermissions.model.CreateIdentitySourceResult;
import com.amazonaws.services.verifiedpermissions.model.CreatePolicyRequest;
import com.amazonaws.services.verifiedpermissions.model.CreatePolicyResult;
import com.amazonaws.services.verifiedpermissions.model.CreatePolicyStoreRequest;
import com.amazonaws.services.verifiedpermissions.model.CreatePolicyStoreResult;
import com.amazonaws.services.verifiedpermissions.model.CreatePolicyTemplateRequest;
import com.amazonaws.services.verifiedpermissions.model.CreatePolicyTemplateResult;
import com.amazonaws.services.verifiedpermissions.model.DeleteIdentitySourceRequest;
import com.amazonaws.services.verifiedpermissions.model.DeleteIdentitySourceResult;
import com.amazonaws.services.verifiedpermissions.model.DeletePolicyRequest;
import com.amazonaws.services.verifiedpermissions.model.DeletePolicyResult;
import com.amazonaws.services.verifiedpermissions.model.DeletePolicyStoreRequest;
import com.amazonaws.services.verifiedpermissions.model.DeletePolicyStoreResult;
import com.amazonaws.services.verifiedpermissions.model.DeletePolicyTemplateRequest;
import com.amazonaws.services.verifiedpermissions.model.DeletePolicyTemplateResult;
import com.amazonaws.services.verifiedpermissions.model.GetIdentitySourceRequest;
import com.amazonaws.services.verifiedpermissions.model.GetIdentitySourceResult;
import com.amazonaws.services.verifiedpermissions.model.GetPolicyRequest;
import com.amazonaws.services.verifiedpermissions.model.GetPolicyResult;
import com.amazonaws.services.verifiedpermissions.model.GetPolicyStoreRequest;
import com.amazonaws.services.verifiedpermissions.model.GetPolicyStoreResult;
import com.amazonaws.services.verifiedpermissions.model.GetPolicyTemplateRequest;
import com.amazonaws.services.verifiedpermissions.model.GetPolicyTemplateResult;
import com.amazonaws.services.verifiedpermissions.model.GetSchemaRequest;
import com.amazonaws.services.verifiedpermissions.model.GetSchemaResult;
import com.amazonaws.services.verifiedpermissions.model.IsAuthorizedRequest;
import com.amazonaws.services.verifiedpermissions.model.IsAuthorizedResult;
import com.amazonaws.services.verifiedpermissions.model.IsAuthorizedWithTokenRequest;
import com.amazonaws.services.verifiedpermissions.model.IsAuthorizedWithTokenResult;
import com.amazonaws.services.verifiedpermissions.model.ListIdentitySourcesRequest;
import com.amazonaws.services.verifiedpermissions.model.ListIdentitySourcesResult;
import com.amazonaws.services.verifiedpermissions.model.ListPoliciesRequest;
import com.amazonaws.services.verifiedpermissions.model.ListPoliciesResult;
import com.amazonaws.services.verifiedpermissions.model.ListPolicyStoresRequest;
import com.amazonaws.services.verifiedpermissions.model.ListPolicyStoresResult;
import com.amazonaws.services.verifiedpermissions.model.ListPolicyTemplatesRequest;
import com.amazonaws.services.verifiedpermissions.model.ListPolicyTemplatesResult;
import com.amazonaws.services.verifiedpermissions.model.PutSchemaRequest;
import com.amazonaws.services.verifiedpermissions.model.PutSchemaResult;
import com.amazonaws.services.verifiedpermissions.model.UpdateIdentitySourceRequest;
import com.amazonaws.services.verifiedpermissions.model.UpdateIdentitySourceResult;
import com.amazonaws.services.verifiedpermissions.model.UpdatePolicyRequest;
import com.amazonaws.services.verifiedpermissions.model.UpdatePolicyResult;
import com.amazonaws.services.verifiedpermissions.model.UpdatePolicyStoreRequest;
import com.amazonaws.services.verifiedpermissions.model.UpdatePolicyStoreResult;
import com.amazonaws.services.verifiedpermissions.model.UpdatePolicyTemplateRequest;
import com.amazonaws.services.verifiedpermissions.model.UpdatePolicyTemplateResult;
import com.amazonaws.services.verifiedpermissions.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.BatchIsAuthorizedRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.BatchIsAuthorizedResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.BatchIsAuthorizedWithTokenRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.BatchIsAuthorizedWithTokenResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.CreateIdentitySourceRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.CreateIdentitySourceResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.CreatePolicyRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.CreatePolicyResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.CreatePolicyStoreRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.CreatePolicyStoreResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.CreatePolicyTemplateRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.CreatePolicyTemplateResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.DeleteIdentitySourceRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.DeleteIdentitySourceResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.DeletePolicyRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.DeletePolicyResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.DeletePolicyStoreRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.DeletePolicyStoreResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.DeletePolicyTemplateRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.DeletePolicyTemplateResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.GetIdentitySourceRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.GetIdentitySourceResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.GetPolicyRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.GetPolicyResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.GetPolicyStoreRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.GetPolicyStoreResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.GetPolicyTemplateRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.GetPolicyTemplateResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.GetSchemaRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.GetSchemaResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.IsAuthorizedRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.IsAuthorizedResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.IsAuthorizedWithTokenRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.IsAuthorizedWithTokenResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.ListIdentitySourcesRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.ListIdentitySourcesResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.ListPoliciesRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.ListPoliciesResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.ListPolicyStoresRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.ListPolicyStoresResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.ListPolicyTemplatesRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.ListPolicyTemplatesResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.PutSchemaRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.PutSchemaResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.UpdateIdentitySourceRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.UpdateIdentitySourceResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.UpdatePolicyRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.UpdatePolicyResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.UpdatePolicyStoreRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.UpdatePolicyStoreResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.UpdatePolicyTemplateRequestProtocolMarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.UpdatePolicyTemplateResultJsonUnmarshaller;
import com.amazonaws.services.verifiedpermissions.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonVerifiedPermissionsClient
extends AmazonWebServiceClient
implements AmazonVerifiedPermissions {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonVerifiedPermissions.class);
    private static final String DEFAULT_SIGNING_NAME = "verifiedpermissions";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonVerifiedPermissionsException.class));

    public static AmazonVerifiedPermissionsClientBuilder builder() {
        return AmazonVerifiedPermissionsClientBuilder.standard();
    }

    AmazonVerifiedPermissionsClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonVerifiedPermissionsClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("verifiedpermissions.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/verifiedpermissions/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/verifiedpermissions/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchIsAuthorizedResult batchIsAuthorized(BatchIsAuthorizedRequest request) {
        request = (BatchIsAuthorizedRequest)this.beforeClientExecution(request);
        return this.executeBatchIsAuthorized(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchIsAuthorizedResult executeBatchIsAuthorized(BatchIsAuthorizedRequest batchIsAuthorizedRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchIsAuthorizedRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchIsAuthorizedRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchIsAuthorizedRequestProtocolMarshaller(protocolFactory).marshall((BatchIsAuthorizedRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchIsAuthorizedRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchIsAuthorized");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchIsAuthorizedResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchIsAuthorizedResult batchIsAuthorizedResult = (BatchIsAuthorizedResult)response.getAwsResponse();
            return batchIsAuthorizedResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchIsAuthorizedWithTokenResult batchIsAuthorizedWithToken(BatchIsAuthorizedWithTokenRequest request) {
        request = (BatchIsAuthorizedWithTokenRequest)this.beforeClientExecution(request);
        return this.executeBatchIsAuthorizedWithToken(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchIsAuthorizedWithTokenResult executeBatchIsAuthorizedWithToken(BatchIsAuthorizedWithTokenRequest batchIsAuthorizedWithTokenRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchIsAuthorizedWithTokenRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchIsAuthorizedWithTokenRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchIsAuthorizedWithTokenRequestProtocolMarshaller(protocolFactory).marshall((BatchIsAuthorizedWithTokenRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchIsAuthorizedWithTokenRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchIsAuthorizedWithToken");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchIsAuthorizedWithTokenResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchIsAuthorizedWithTokenResult batchIsAuthorizedWithTokenResult = (BatchIsAuthorizedWithTokenResult)response.getAwsResponse();
            return batchIsAuthorizedWithTokenResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateIdentitySourceResult createIdentitySource(CreateIdentitySourceRequest request) {
        request = (CreateIdentitySourceRequest)this.beforeClientExecution(request);
        return this.executeCreateIdentitySource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateIdentitySourceResult executeCreateIdentitySource(CreateIdentitySourceRequest createIdentitySourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createIdentitySourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateIdentitySourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateIdentitySourceRequestProtocolMarshaller(protocolFactory).marshall((CreateIdentitySourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)createIdentitySourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateIdentitySource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateIdentitySourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateIdentitySourceResult createIdentitySourceResult = (CreateIdentitySourceResult)response.getAwsResponse();
            return createIdentitySourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreatePolicyResult createPolicy(CreatePolicyRequest request) {
        request = (CreatePolicyRequest)this.beforeClientExecution(request);
        return this.executeCreatePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePolicyResult executeCreatePolicy(CreatePolicyRequest createPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePolicyRequestProtocolMarshaller(protocolFactory).marshall((CreatePolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreatePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePolicyResult createPolicyResult = (CreatePolicyResult)response.getAwsResponse();
            return createPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreatePolicyStoreResult createPolicyStore(CreatePolicyStoreRequest request) {
        request = (CreatePolicyStoreRequest)this.beforeClientExecution(request);
        return this.executeCreatePolicyStore(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePolicyStoreResult executeCreatePolicyStore(CreatePolicyStoreRequest createPolicyStoreRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPolicyStoreRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePolicyStoreRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePolicyStoreRequestProtocolMarshaller(protocolFactory).marshall((CreatePolicyStoreRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPolicyStoreRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreatePolicyStore");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePolicyStoreResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePolicyStoreResult createPolicyStoreResult = (CreatePolicyStoreResult)response.getAwsResponse();
            return createPolicyStoreResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreatePolicyTemplateResult createPolicyTemplate(CreatePolicyTemplateRequest request) {
        request = (CreatePolicyTemplateRequest)this.beforeClientExecution(request);
        return this.executeCreatePolicyTemplate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePolicyTemplateResult executeCreatePolicyTemplate(CreatePolicyTemplateRequest createPolicyTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPolicyTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePolicyTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePolicyTemplateRequestProtocolMarshaller(protocolFactory).marshall((CreatePolicyTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPolicyTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreatePolicyTemplate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePolicyTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePolicyTemplateResult createPolicyTemplateResult = (CreatePolicyTemplateResult)response.getAwsResponse();
            return createPolicyTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteIdentitySourceResult deleteIdentitySource(DeleteIdentitySourceRequest request) {
        request = (DeleteIdentitySourceRequest)this.beforeClientExecution(request);
        return this.executeDeleteIdentitySource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteIdentitySourceResult executeDeleteIdentitySource(DeleteIdentitySourceRequest deleteIdentitySourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteIdentitySourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteIdentitySourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteIdentitySourceRequestProtocolMarshaller(protocolFactory).marshall((DeleteIdentitySourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteIdentitySourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteIdentitySource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteIdentitySourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteIdentitySourceResult deleteIdentitySourceResult = (DeleteIdentitySourceResult)response.getAwsResponse();
            return deleteIdentitySourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePolicyResult deletePolicy(DeletePolicyRequest request) {
        request = (DeletePolicyRequest)this.beforeClientExecution(request);
        return this.executeDeletePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePolicyResult executeDeletePolicy(DeletePolicyRequest deletePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePolicyRequestProtocolMarshaller(protocolFactory).marshall((DeletePolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeletePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePolicyResult deletePolicyResult = (DeletePolicyResult)response.getAwsResponse();
            return deletePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePolicyStoreResult deletePolicyStore(DeletePolicyStoreRequest request) {
        request = (DeletePolicyStoreRequest)this.beforeClientExecution(request);
        return this.executeDeletePolicyStore(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePolicyStoreResult executeDeletePolicyStore(DeletePolicyStoreRequest deletePolicyStoreRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePolicyStoreRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePolicyStoreRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePolicyStoreRequestProtocolMarshaller(protocolFactory).marshall((DeletePolicyStoreRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePolicyStoreRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeletePolicyStore");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePolicyStoreResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePolicyStoreResult deletePolicyStoreResult = (DeletePolicyStoreResult)response.getAwsResponse();
            return deletePolicyStoreResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePolicyTemplateResult deletePolicyTemplate(DeletePolicyTemplateRequest request) {
        request = (DeletePolicyTemplateRequest)this.beforeClientExecution(request);
        return this.executeDeletePolicyTemplate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePolicyTemplateResult executeDeletePolicyTemplate(DeletePolicyTemplateRequest deletePolicyTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePolicyTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePolicyTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePolicyTemplateRequestProtocolMarshaller(protocolFactory).marshall((DeletePolicyTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePolicyTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeletePolicyTemplate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePolicyTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePolicyTemplateResult deletePolicyTemplateResult = (DeletePolicyTemplateResult)response.getAwsResponse();
            return deletePolicyTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetIdentitySourceResult getIdentitySource(GetIdentitySourceRequest request) {
        request = (GetIdentitySourceRequest)this.beforeClientExecution(request);
        return this.executeGetIdentitySource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetIdentitySourceResult executeGetIdentitySource(GetIdentitySourceRequest getIdentitySourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getIdentitySourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetIdentitySourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetIdentitySourceRequestProtocolMarshaller(protocolFactory).marshall((GetIdentitySourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)getIdentitySourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetIdentitySource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetIdentitySourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetIdentitySourceResult getIdentitySourceResult = (GetIdentitySourceResult)response.getAwsResponse();
            return getIdentitySourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPolicyResult getPolicy(GetPolicyRequest request) {
        request = (GetPolicyRequest)this.beforeClientExecution(request);
        return this.executeGetPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPolicyResult executeGetPolicy(GetPolicyRequest getPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPolicyRequestProtocolMarshaller(protocolFactory).marshall((GetPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPolicyResult getPolicyResult = (GetPolicyResult)response.getAwsResponse();
            return getPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPolicyStoreResult getPolicyStore(GetPolicyStoreRequest request) {
        request = (GetPolicyStoreRequest)this.beforeClientExecution(request);
        return this.executeGetPolicyStore(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPolicyStoreResult executeGetPolicyStore(GetPolicyStoreRequest getPolicyStoreRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPolicyStoreRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPolicyStoreRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPolicyStoreRequestProtocolMarshaller(protocolFactory).marshall((GetPolicyStoreRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPolicyStoreRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPolicyStore");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPolicyStoreResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPolicyStoreResult getPolicyStoreResult = (GetPolicyStoreResult)response.getAwsResponse();
            return getPolicyStoreResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPolicyTemplateResult getPolicyTemplate(GetPolicyTemplateRequest request) {
        request = (GetPolicyTemplateRequest)this.beforeClientExecution(request);
        return this.executeGetPolicyTemplate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPolicyTemplateResult executeGetPolicyTemplate(GetPolicyTemplateRequest getPolicyTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPolicyTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPolicyTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPolicyTemplateRequestProtocolMarshaller(protocolFactory).marshall((GetPolicyTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPolicyTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPolicyTemplate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPolicyTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPolicyTemplateResult getPolicyTemplateResult = (GetPolicyTemplateResult)response.getAwsResponse();
            return getPolicyTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSchemaResult getSchema(GetSchemaRequest request) {
        request = (GetSchemaRequest)this.beforeClientExecution(request);
        return this.executeGetSchema(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSchemaResult executeGetSchema(GetSchemaRequest getSchemaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSchemaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSchemaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSchemaRequestProtocolMarshaller(protocolFactory).marshall((GetSchemaRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSchemaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSchema");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSchemaResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSchemaResult getSchemaResult = (GetSchemaResult)response.getAwsResponse();
            return getSchemaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public IsAuthorizedResult isAuthorized(IsAuthorizedRequest request) {
        request = (IsAuthorizedRequest)this.beforeClientExecution(request);
        return this.executeIsAuthorized(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final IsAuthorizedResult executeIsAuthorized(IsAuthorizedRequest isAuthorizedRequest) {
        ExecutionContext executionContext = this.createExecutionContext(isAuthorizedRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<IsAuthorizedRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new IsAuthorizedRequestProtocolMarshaller(protocolFactory).marshall((IsAuthorizedRequest)super.beforeMarshalling((AmazonWebServiceRequest)isAuthorizedRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"IsAuthorized");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new IsAuthorizedResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            IsAuthorizedResult isAuthorizedResult = (IsAuthorizedResult)response.getAwsResponse();
            return isAuthorizedResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public IsAuthorizedWithTokenResult isAuthorizedWithToken(IsAuthorizedWithTokenRequest request) {
        request = (IsAuthorizedWithTokenRequest)this.beforeClientExecution(request);
        return this.executeIsAuthorizedWithToken(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final IsAuthorizedWithTokenResult executeIsAuthorizedWithToken(IsAuthorizedWithTokenRequest isAuthorizedWithTokenRequest) {
        ExecutionContext executionContext = this.createExecutionContext(isAuthorizedWithTokenRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<IsAuthorizedWithTokenRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new IsAuthorizedWithTokenRequestProtocolMarshaller(protocolFactory).marshall((IsAuthorizedWithTokenRequest)super.beforeMarshalling((AmazonWebServiceRequest)isAuthorizedWithTokenRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"IsAuthorizedWithToken");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new IsAuthorizedWithTokenResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            IsAuthorizedWithTokenResult isAuthorizedWithTokenResult = (IsAuthorizedWithTokenResult)response.getAwsResponse();
            return isAuthorizedWithTokenResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListIdentitySourcesResult listIdentitySources(ListIdentitySourcesRequest request) {
        request = (ListIdentitySourcesRequest)this.beforeClientExecution(request);
        return this.executeListIdentitySources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListIdentitySourcesResult executeListIdentitySources(ListIdentitySourcesRequest listIdentitySourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listIdentitySourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListIdentitySourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListIdentitySourcesRequestProtocolMarshaller(protocolFactory).marshall((ListIdentitySourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listIdentitySourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListIdentitySources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListIdentitySourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListIdentitySourcesResult listIdentitySourcesResult = (ListIdentitySourcesResult)response.getAwsResponse();
            return listIdentitySourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPoliciesResult listPolicies(ListPoliciesRequest request) {
        request = (ListPoliciesRequest)this.beforeClientExecution(request);
        return this.executeListPolicies(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPoliciesResult executeListPolicies(ListPoliciesRequest listPoliciesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPoliciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPoliciesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPoliciesRequestProtocolMarshaller(protocolFactory).marshall((ListPoliciesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPoliciesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPolicies");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPoliciesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPoliciesResult listPoliciesResult = (ListPoliciesResult)response.getAwsResponse();
            return listPoliciesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPolicyStoresResult listPolicyStores(ListPolicyStoresRequest request) {
        request = (ListPolicyStoresRequest)this.beforeClientExecution(request);
        return this.executeListPolicyStores(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPolicyStoresResult executeListPolicyStores(ListPolicyStoresRequest listPolicyStoresRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPolicyStoresRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPolicyStoresRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPolicyStoresRequestProtocolMarshaller(protocolFactory).marshall((ListPolicyStoresRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPolicyStoresRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPolicyStores");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPolicyStoresResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPolicyStoresResult listPolicyStoresResult = (ListPolicyStoresResult)response.getAwsResponse();
            return listPolicyStoresResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPolicyTemplatesResult listPolicyTemplates(ListPolicyTemplatesRequest request) {
        request = (ListPolicyTemplatesRequest)this.beforeClientExecution(request);
        return this.executeListPolicyTemplates(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPolicyTemplatesResult executeListPolicyTemplates(ListPolicyTemplatesRequest listPolicyTemplatesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPolicyTemplatesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPolicyTemplatesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPolicyTemplatesRequestProtocolMarshaller(protocolFactory).marshall((ListPolicyTemplatesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPolicyTemplatesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPolicyTemplates");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPolicyTemplatesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPolicyTemplatesResult listPolicyTemplatesResult = (ListPolicyTemplatesResult)response.getAwsResponse();
            return listPolicyTemplatesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutSchemaResult putSchema(PutSchemaRequest request) {
        request = (PutSchemaRequest)this.beforeClientExecution(request);
        return this.executePutSchema(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutSchemaResult executePutSchema(PutSchemaRequest putSchemaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putSchemaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutSchemaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutSchemaRequestProtocolMarshaller(protocolFactory).marshall((PutSchemaRequest)super.beforeMarshalling((AmazonWebServiceRequest)putSchemaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutSchema");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutSchemaResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutSchemaResult putSchemaResult = (PutSchemaResult)response.getAwsResponse();
            return putSchemaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateIdentitySourceResult updateIdentitySource(UpdateIdentitySourceRequest request) {
        request = (UpdateIdentitySourceRequest)this.beforeClientExecution(request);
        return this.executeUpdateIdentitySource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateIdentitySourceResult executeUpdateIdentitySource(UpdateIdentitySourceRequest updateIdentitySourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateIdentitySourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateIdentitySourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateIdentitySourceRequestProtocolMarshaller(protocolFactory).marshall((UpdateIdentitySourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateIdentitySourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateIdentitySource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateIdentitySourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateIdentitySourceResult updateIdentitySourceResult = (UpdateIdentitySourceResult)response.getAwsResponse();
            return updateIdentitySourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdatePolicyResult updatePolicy(UpdatePolicyRequest request) {
        request = (UpdatePolicyRequest)this.beforeClientExecution(request);
        return this.executeUpdatePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdatePolicyResult executeUpdatePolicy(UpdatePolicyRequest updatePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updatePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePolicyRequestProtocolMarshaller(protocolFactory).marshall((UpdatePolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)updatePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdatePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdatePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdatePolicyResult updatePolicyResult = (UpdatePolicyResult)response.getAwsResponse();
            return updatePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdatePolicyStoreResult updatePolicyStore(UpdatePolicyStoreRequest request) {
        request = (UpdatePolicyStoreRequest)this.beforeClientExecution(request);
        return this.executeUpdatePolicyStore(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdatePolicyStoreResult executeUpdatePolicyStore(UpdatePolicyStoreRequest updatePolicyStoreRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updatePolicyStoreRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePolicyStoreRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePolicyStoreRequestProtocolMarshaller(protocolFactory).marshall((UpdatePolicyStoreRequest)super.beforeMarshalling((AmazonWebServiceRequest)updatePolicyStoreRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdatePolicyStore");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdatePolicyStoreResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdatePolicyStoreResult updatePolicyStoreResult = (UpdatePolicyStoreResult)response.getAwsResponse();
            return updatePolicyStoreResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdatePolicyTemplateResult updatePolicyTemplate(UpdatePolicyTemplateRequest request) {
        request = (UpdatePolicyTemplateRequest)this.beforeClientExecution(request);
        return this.executeUpdatePolicyTemplate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdatePolicyTemplateResult executeUpdatePolicyTemplate(UpdatePolicyTemplateRequest updatePolicyTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updatePolicyTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePolicyTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePolicyTemplateRequestProtocolMarshaller(protocolFactory).marshall((UpdatePolicyTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)updatePolicyTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"VerifiedPermissions");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdatePolicyTemplate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdatePolicyTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdatePolicyTemplateResult updatePolicyTemplateResult = (UpdatePolicyTemplateResult)response.getAwsResponse();
            return updatePolicyTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

