/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.trustedadvisor.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.trustedadvisor.model.RecommendationSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListRecommendationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<RecommendationSummary> recommendationSummaries;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListRecommendationsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<RecommendationSummary> getRecommendationSummaries() {
        return this.recommendationSummaries;
    }

    public void setRecommendationSummaries(Collection<RecommendationSummary> recommendationSummaries) {
        if (recommendationSummaries == null) {
            this.recommendationSummaries = null;
            return;
        }
        this.recommendationSummaries = new ArrayList<RecommendationSummary>(recommendationSummaries);
    }

    public ListRecommendationsResult withRecommendationSummaries(RecommendationSummary ... recommendationSummaries) {
        if (this.recommendationSummaries == null) {
            this.setRecommendationSummaries(new ArrayList<RecommendationSummary>(recommendationSummaries.length));
        }
        for (RecommendationSummary ele : recommendationSummaries) {
            this.recommendationSummaries.add(ele);
        }
        return this;
    }

    public ListRecommendationsResult withRecommendationSummaries(Collection<RecommendationSummary> recommendationSummaries) {
        this.setRecommendationSummaries(recommendationSummaries);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getRecommendationSummaries() != null) {
            sb.append("RecommendationSummaries: ").append(this.getRecommendationSummaries());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationsResult)) {
            return false;
        }
        ListRecommendationsResult other = (ListRecommendationsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getRecommendationSummaries() == null ^ this.getRecommendationSummaries() == null) {
            return false;
        }
        return other.getRecommendationSummaries() == null || other.getRecommendationSummaries().equals(this.getRecommendationSummaries());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationSummaries() == null ? 0 : this.getRecommendationSummaries().hashCode());
        return hashCode;
    }

    public ListRecommendationsResult clone() {
        try {
            return (ListRecommendationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

