/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate.model.transform;

import com.amazonaws.services.translate.model.Document;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;

public class DocumentJsonUnmarshaller
implements Unmarshaller<Document, JsonUnmarshallerContext> {
    private static DocumentJsonUnmarshaller instance;

    public Document unmarshall(JsonUnmarshallerContext context) throws Exception {
        Document document = new Document();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Content", targetDepth)) {
                    context.nextToken();
                    document.setContent((ByteBuffer)context.getUnmarshaller(ByteBuffer.class).unmarshall((Object)context));
                }
                if (context.testExpression("ContentType", targetDepth)) {
                    context.nextToken();
                    document.setContentType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return document;
    }

    public static DocumentJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DocumentJsonUnmarshaller();
        }
        return instance;
    }
}

