/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.translate.model.transform.DocumentMarshaller;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class Document
implements Serializable,
Cloneable,
StructuredPojo {
    private ByteBuffer content;
    private String contentType;

    public void setContent(ByteBuffer content) {
        this.content = content;
    }

    public ByteBuffer getContent() {
        return this.content;
    }

    public Document withContent(ByteBuffer content) {
        this.setContent(content);
        return this;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Document withContentType(String contentType) {
        this.setContentType(contentType);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContent() != null) {
            sb.append("Content: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getContentType() != null) {
            sb.append("ContentType: ").append(this.getContentType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Document)) {
            return false;
        }
        Document other = (Document)obj;
        if (other.getContent() == null ^ this.getContent() == null) {
            return false;
        }
        if (other.getContent() != null && !other.getContent().equals(this.getContent())) {
            return false;
        }
        if (other.getContentType() == null ^ this.getContentType() == null) {
            return false;
        }
        return other.getContentType() == null || other.getContentType().equals(this.getContentType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContent() == null ? 0 : this.getContent().hashCode());
        hashCode = 31 * hashCode + (this.getContentType() == null ? 0 : this.getContentType().hashCode());
        return hashCode;
    }

    public Document clone() {
        try {
            return (Document)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

