/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.translate.AmazonTranslateAsync;
import com.amazonaws.services.translate.AmazonTranslateAsyncClientBuilder;
import com.amazonaws.services.translate.AmazonTranslateClient;
import com.amazonaws.services.translate.model.CreateParallelDataRequest;
import com.amazonaws.services.translate.model.CreateParallelDataResult;
import com.amazonaws.services.translate.model.DeleteParallelDataRequest;
import com.amazonaws.services.translate.model.DeleteParallelDataResult;
import com.amazonaws.services.translate.model.DeleteTerminologyRequest;
import com.amazonaws.services.translate.model.DeleteTerminologyResult;
import com.amazonaws.services.translate.model.DescribeTextTranslationJobRequest;
import com.amazonaws.services.translate.model.DescribeTextTranslationJobResult;
import com.amazonaws.services.translate.model.GetParallelDataRequest;
import com.amazonaws.services.translate.model.GetParallelDataResult;
import com.amazonaws.services.translate.model.GetTerminologyRequest;
import com.amazonaws.services.translate.model.GetTerminologyResult;
import com.amazonaws.services.translate.model.ImportTerminologyRequest;
import com.amazonaws.services.translate.model.ImportTerminologyResult;
import com.amazonaws.services.translate.model.ListLanguagesRequest;
import com.amazonaws.services.translate.model.ListLanguagesResult;
import com.amazonaws.services.translate.model.ListParallelDataRequest;
import com.amazonaws.services.translate.model.ListParallelDataResult;
import com.amazonaws.services.translate.model.ListTerminologiesRequest;
import com.amazonaws.services.translate.model.ListTerminologiesResult;
import com.amazonaws.services.translate.model.ListTextTranslationJobsRequest;
import com.amazonaws.services.translate.model.ListTextTranslationJobsResult;
import com.amazonaws.services.translate.model.StartTextTranslationJobRequest;
import com.amazonaws.services.translate.model.StartTextTranslationJobResult;
import com.amazonaws.services.translate.model.StopTextTranslationJobRequest;
import com.amazonaws.services.translate.model.StopTextTranslationJobResult;
import com.amazonaws.services.translate.model.TranslateTextRequest;
import com.amazonaws.services.translate.model.TranslateTextResult;
import com.amazonaws.services.translate.model.UpdateParallelDataRequest;
import com.amazonaws.services.translate.model.UpdateParallelDataResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonTranslateAsyncClient
extends AmazonTranslateClient
implements AmazonTranslateAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonTranslateAsyncClientBuilder asyncBuilder() {
        return AmazonTranslateAsyncClientBuilder.standard();
    }

    AmazonTranslateAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonTranslateAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateParallelDataResult> createParallelDataAsync(CreateParallelDataRequest request) {
        return this.createParallelDataAsync(request, null);
    }

    @Override
    public Future<CreateParallelDataResult> createParallelDataAsync(CreateParallelDataRequest request, final AsyncHandler<CreateParallelDataRequest, CreateParallelDataResult> asyncHandler) {
        final CreateParallelDataRequest finalRequest = (CreateParallelDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateParallelDataResult>(){

            @Override
            public CreateParallelDataResult call() throws Exception {
                CreateParallelDataResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeCreateParallelData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteParallelDataResult> deleteParallelDataAsync(DeleteParallelDataRequest request) {
        return this.deleteParallelDataAsync(request, null);
    }

    @Override
    public Future<DeleteParallelDataResult> deleteParallelDataAsync(DeleteParallelDataRequest request, final AsyncHandler<DeleteParallelDataRequest, DeleteParallelDataResult> asyncHandler) {
        final DeleteParallelDataRequest finalRequest = (DeleteParallelDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteParallelDataResult>(){

            @Override
            public DeleteParallelDataResult call() throws Exception {
                DeleteParallelDataResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeDeleteParallelData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTerminologyResult> deleteTerminologyAsync(DeleteTerminologyRequest request) {
        return this.deleteTerminologyAsync(request, null);
    }

    @Override
    public Future<DeleteTerminologyResult> deleteTerminologyAsync(DeleteTerminologyRequest request, final AsyncHandler<DeleteTerminologyRequest, DeleteTerminologyResult> asyncHandler) {
        final DeleteTerminologyRequest finalRequest = (DeleteTerminologyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTerminologyResult>(){

            @Override
            public DeleteTerminologyResult call() throws Exception {
                DeleteTerminologyResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeDeleteTerminology(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTextTranslationJobResult> describeTextTranslationJobAsync(DescribeTextTranslationJobRequest request) {
        return this.describeTextTranslationJobAsync(request, null);
    }

    @Override
    public Future<DescribeTextTranslationJobResult> describeTextTranslationJobAsync(DescribeTextTranslationJobRequest request, final AsyncHandler<DescribeTextTranslationJobRequest, DescribeTextTranslationJobResult> asyncHandler) {
        final DescribeTextTranslationJobRequest finalRequest = (DescribeTextTranslationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTextTranslationJobResult>(){

            @Override
            public DescribeTextTranslationJobResult call() throws Exception {
                DescribeTextTranslationJobResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeDescribeTextTranslationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetParallelDataResult> getParallelDataAsync(GetParallelDataRequest request) {
        return this.getParallelDataAsync(request, null);
    }

    @Override
    public Future<GetParallelDataResult> getParallelDataAsync(GetParallelDataRequest request, final AsyncHandler<GetParallelDataRequest, GetParallelDataResult> asyncHandler) {
        final GetParallelDataRequest finalRequest = (GetParallelDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetParallelDataResult>(){

            @Override
            public GetParallelDataResult call() throws Exception {
                GetParallelDataResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeGetParallelData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTerminologyResult> getTerminologyAsync(GetTerminologyRequest request) {
        return this.getTerminologyAsync(request, null);
    }

    @Override
    public Future<GetTerminologyResult> getTerminologyAsync(GetTerminologyRequest request, final AsyncHandler<GetTerminologyRequest, GetTerminologyResult> asyncHandler) {
        final GetTerminologyRequest finalRequest = (GetTerminologyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTerminologyResult>(){

            @Override
            public GetTerminologyResult call() throws Exception {
                GetTerminologyResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeGetTerminology(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ImportTerminologyResult> importTerminologyAsync(ImportTerminologyRequest request) {
        return this.importTerminologyAsync(request, null);
    }

    @Override
    public Future<ImportTerminologyResult> importTerminologyAsync(ImportTerminologyRequest request, final AsyncHandler<ImportTerminologyRequest, ImportTerminologyResult> asyncHandler) {
        final ImportTerminologyRequest finalRequest = (ImportTerminologyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ImportTerminologyResult>(){

            @Override
            public ImportTerminologyResult call() throws Exception {
                ImportTerminologyResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeImportTerminology(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLanguagesResult> listLanguagesAsync(ListLanguagesRequest request) {
        return this.listLanguagesAsync(request, null);
    }

    @Override
    public Future<ListLanguagesResult> listLanguagesAsync(ListLanguagesRequest request, final AsyncHandler<ListLanguagesRequest, ListLanguagesResult> asyncHandler) {
        final ListLanguagesRequest finalRequest = (ListLanguagesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListLanguagesResult>(){

            @Override
            public ListLanguagesResult call() throws Exception {
                ListLanguagesResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeListLanguages(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListParallelDataResult> listParallelDataAsync(ListParallelDataRequest request) {
        return this.listParallelDataAsync(request, null);
    }

    @Override
    public Future<ListParallelDataResult> listParallelDataAsync(ListParallelDataRequest request, final AsyncHandler<ListParallelDataRequest, ListParallelDataResult> asyncHandler) {
        final ListParallelDataRequest finalRequest = (ListParallelDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListParallelDataResult>(){

            @Override
            public ListParallelDataResult call() throws Exception {
                ListParallelDataResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeListParallelData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTerminologiesResult> listTerminologiesAsync(ListTerminologiesRequest request) {
        return this.listTerminologiesAsync(request, null);
    }

    @Override
    public Future<ListTerminologiesResult> listTerminologiesAsync(ListTerminologiesRequest request, final AsyncHandler<ListTerminologiesRequest, ListTerminologiesResult> asyncHandler) {
        final ListTerminologiesRequest finalRequest = (ListTerminologiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTerminologiesResult>(){

            @Override
            public ListTerminologiesResult call() throws Exception {
                ListTerminologiesResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeListTerminologies(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTextTranslationJobsResult> listTextTranslationJobsAsync(ListTextTranslationJobsRequest request) {
        return this.listTextTranslationJobsAsync(request, null);
    }

    @Override
    public Future<ListTextTranslationJobsResult> listTextTranslationJobsAsync(ListTextTranslationJobsRequest request, final AsyncHandler<ListTextTranslationJobsRequest, ListTextTranslationJobsResult> asyncHandler) {
        final ListTextTranslationJobsRequest finalRequest = (ListTextTranslationJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTextTranslationJobsResult>(){

            @Override
            public ListTextTranslationJobsResult call() throws Exception {
                ListTextTranslationJobsResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeListTextTranslationJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartTextTranslationJobResult> startTextTranslationJobAsync(StartTextTranslationJobRequest request) {
        return this.startTextTranslationJobAsync(request, null);
    }

    @Override
    public Future<StartTextTranslationJobResult> startTextTranslationJobAsync(StartTextTranslationJobRequest request, final AsyncHandler<StartTextTranslationJobRequest, StartTextTranslationJobResult> asyncHandler) {
        final StartTextTranslationJobRequest finalRequest = (StartTextTranslationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartTextTranslationJobResult>(){

            @Override
            public StartTextTranslationJobResult call() throws Exception {
                StartTextTranslationJobResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeStartTextTranslationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopTextTranslationJobResult> stopTextTranslationJobAsync(StopTextTranslationJobRequest request) {
        return this.stopTextTranslationJobAsync(request, null);
    }

    @Override
    public Future<StopTextTranslationJobResult> stopTextTranslationJobAsync(StopTextTranslationJobRequest request, final AsyncHandler<StopTextTranslationJobRequest, StopTextTranslationJobResult> asyncHandler) {
        final StopTextTranslationJobRequest finalRequest = (StopTextTranslationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopTextTranslationJobResult>(){

            @Override
            public StopTextTranslationJobResult call() throws Exception {
                StopTextTranslationJobResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeStopTextTranslationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TranslateTextResult> translateTextAsync(TranslateTextRequest request) {
        return this.translateTextAsync(request, null);
    }

    @Override
    public Future<TranslateTextResult> translateTextAsync(TranslateTextRequest request, final AsyncHandler<TranslateTextRequest, TranslateTextResult> asyncHandler) {
        final TranslateTextRequest finalRequest = (TranslateTextRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TranslateTextResult>(){

            @Override
            public TranslateTextResult call() throws Exception {
                TranslateTextResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeTranslateText(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateParallelDataResult> updateParallelDataAsync(UpdateParallelDataRequest request) {
        return this.updateParallelDataAsync(request, null);
    }

    @Override
    public Future<UpdateParallelDataResult> updateParallelDataAsync(UpdateParallelDataRequest request, final AsyncHandler<UpdateParallelDataRequest, UpdateParallelDataResult> asyncHandler) {
        final UpdateParallelDataRequest finalRequest = (UpdateParallelDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateParallelDataResult>(){

            @Override
            public UpdateParallelDataResult call() throws Exception {
                UpdateParallelDataResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeUpdateParallelData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

